<%@ page import="org.eclipse.soda.stepstone.backend.patients.Constants" %>
<%@ page import="org.eclipse.soda.stepstone.backend.patients.model.Patient" %>
<%@ page import="java.util.Iterator"%>

<jsp:useBean id="actionUrl" type="java.lang.String" scope="request" />
<jsp:useBean id="url" type="java.lang.String" scope="request" />
<jsp:useBean id="patientList" type="java.util.List" scope="request"/>

<script type="text/javascript">
function showSelected(){
	if(patient = getSelected()){
		document.getElementById("action").value="<%=Constants.ACTION_VIEW_PATIENT%>";
		document.getElementById("patientId").value=patient;
		document.patientForm.submit();	
	}
	else alert("No rows are selected.");
}
function editSelected(){
	if(patient = getSelected()){
		document.getElementById("action").value="<%=Constants.ACTION_TO_EDIT_PATIENT%>";
		document.getElementById("patientId").value=patient;
		document.patientForm.submit();	
	}
	else alert("No rows are selected.");
}
function deleteSelected(){
	if(patient = getSelected()){
		//TODO: may not work with pop-up blockers
		var conf=confirm("Are you sure that you would "+
				"like to delete patient #: " + patient);
		if(conf==true){
			document.getElementById("action").value="<%=Constants.ACTION_DELETE_PATIENT%>";
			document.getElementById("patientId").value=patient;
			document.patientForm.submit();	
		}
		else{
			alert("Delete cancelled: no action taken");
		}
	}
	else alert("No rows are selected.");
}
//returns the selected patient if none are selected
function getSelected(){
	var patientTable=dijit.byId("patientTable");
	if(patientTable){
		var selectedPatient = patientTable.model.getDatum(patientTable.selection.getSelected(),0);
	}
	return selectedPatient;
}

var view =	{ cells: [[{name: 'Patient Id', width: '200px', field: 'PatientId'}, 
					{name: 'Name', width: '200px', field:'Name'},
					{name: 'Address', width: '200px', field:'Address'},
					{name: 'Date Of Birth', width: '200px', field:'DateOfBirth'}]]
			};
var layout = [ view ];
</script>

<div>
	<button onclick="showSelected();">Select Patient</button>
	<button onclick="editSelected();">Edit Patient</button>
	<button onclick="deleteSelected();">Delete Patient</button>
</div>

<div dojoType="dojox.data.HtmlTableStore" tableId="patientTable" jsId="tableStore"></div>
<div dojoType="dojox.grid.data.DojoData" store="tableStore" query="{}" jsId="model"></div>

<table id="patientTable" dojoType="dojox.Grid" model="model" structure="layout" style="height: 300px; width: 830px;">
	<thead>
		<tr>
			<th>PatientId</th>
			<th>Name</th>
			<th>Address</th>
			<th>DateOfBirth</th>
		</tr>
	</thead>

	<tbody>
<%
	
	for (Iterator iterator = patientList.iterator(); iterator.hasNext(); ) {
		Patient patient = (Patient) iterator.next();
		out.println("<tr>");
		out.println("<td>" + patient.getId() + "</td>");
		out.println("<td>" + patient.getLastName() + ", " + 
				patient.getFirstName() + "</td>");
		out.println("<td>" + patient.getAddress() + "</td>");
		out.println("<td>" + patient.getDateOfBirth() + "</td>");
		out.println("</tr>");
	}
%>
	</tbody>
</table>

<form name="patientForm" action="<%=actionUrl%>" method="post" style="visibility: hidden; display: none;">
	<input id="action" name="<%=Constants.PARAM_ACTION%>" type="text" />
	<input id="patientId" name="<%=Constants.PARAM_ID%>" type="text" />
	<input id="url" name="url" type="text" value="<%=url%>"/>
</form>