/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients.communications;

import java.sql.Date;
import java.text.ParseException;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.service.device.IDataMessageParser;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;

public class PatientParser
implements IDataMessageParser {
    private static final int NUMOFPARAMS = 5;

    public IDataObject getNewComponentReading() {
        return new Patient();
    }

    public IDataObject parseDataMessage(String messageValue) throws ParseException {
        try {
            Patient patient = new Patient();
            String[] subMessages = messageValue.split("\\|");
            if (subMessages.length != 5) {
                throw new ParseException("Invalid Blood Pressure Reading", 0);
            }
            patient.setId(subMessages[0]);
            patient.setFirstName(subMessages[1]);
            patient.setLastName(subMessages[2]);
            patient.setAddressLine1(subMessages[3]);
            patient.setDateOfBirth(Date.valueOf(subMessages[4]));
            return patient;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid Patient Info", 0);
        }
    }

    public IDataObject parseMessage(String message, String unitId, String deviceId, String dateTime) throws ParseException {
        return null;
    }
}

