/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients.model;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDataObject;
import org.eclipse.soda.stepstone.backend.service.patient.IPatient;

public class Patient
implements IDataObject,
IPatient {
    private String id;
    private String firstName;
    private String lastName;
    private String address1;
    private String address2;
    private Date dateOfBirth;
    private boolean isMale;
    private String ethnicity;
    private String contactFirstName;
    private String contactLastName;
    private String contactHomePhone;
    private String contactCellPhone;
    private String contactCellCarrier;

    public Patient(Map m) {
        this.id = (String)m.get("PATIENT_ID");
        this.firstName = (String)m.get("FNAME");
        this.lastName = (String)m.get("LNAME");
        this.address1 = (String)m.get("ADDR_L1");
        this.address2 = (String)m.get("ADDR_L2");
        this.dateOfBirth = (Date)m.get("DOB");
        this.isMale = (Integer)m.get("MALE") == 1;
        this.ethnicity = (String)m.get("ETHNICITY");
        this.contactFirstName = (String)m.get("CONTACT_FIRST_NAME");
        this.contactLastName = (String)m.get("CONTACT_LAST_NAME");
        this.contactHomePhone = (String)m.get("PHONE");
        this.contactCellPhone = (String)m.get("CELL");
        this.contactCellCarrier = (String)m.get("CELL_CARRIER");
    }

    public Patient() {
    }

    protected Map getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PATIENT_ID", this.id);
        map.put("FNAME", this.firstName);
        map.put("LNAME", this.lastName);
        map.put("ADDR_L1", this.address1);
        map.put("ADDR_L2", this.address2);
        map.put("DOB", this.dateOfBirth);
        map.put("MALE", new Integer(this.isMale ? 1 : 0));
        map.put("ETHNICITY", this.ethnicity);
        map.put("CONTACT_FIRST_NAME", this.contactFirstName);
        map.put("CONTACT_LAST_NAME", this.contactLastName);
        map.put("PHONE", this.contactHomePhone);
        map.put("CELL", this.contactCellPhone);
        map.put("CELL_CARRIER", this.contactCellCarrier);
        return map;
    }

    public void updateInDatabase(IDatabaseConnection c) throws StepstoneDatabaseException {
        c.updateItem("patient", this.getMap(), "PATIENT_ID");
    }

    public String getXmlElement() {
        Map map = this.getMap();
        StringWriter writer = new StringWriter();
        Iterator keyIterator = map.keySet().iterator();
        writer.write("<patient>");
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = map.get(key);
            writer.write("<" + key + ">" + value.toString() + "</" + key + ">");
        }
        writer.write("</patient>");
        return writer.toString();
    }

    public void writeToDatabase(IDatabaseConnection conn) throws StepstoneDatabaseException {
        conn.insertItem("patient", this.getMap());
    }

    public String getFullName() {
        return String.valueOf(this.firstName) + " " + this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getAddressLine1() {
        return this.address1;
    }

    public void setAddressLine1(String address1) {
        this.address1 = address1;
    }

    public String getAddressLine2() {
        return this.address2;
    }

    public void setAddressLine2(String address2) {
        this.address2 = address2;
    }

    public boolean getIsMale() {
        return this.isMale;
    }

    public void setIsMale(boolean isMale) {
        this.isMale = isMale;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public String getAddress() {
        return String.valueOf(this.address1) + "; " + this.address2;
    }

    public String getContactCellPhone() {
        return this.contactCellPhone;
    }

    public void setContactCellPhone(String contactCellPhone) {
        this.contactCellPhone = contactCellPhone;
    }

    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public void setContactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
    }

    public String getContactHomePhone() {
        return this.contactHomePhone;
    }

    public void setContactHomePhone(String contactHomePhone) {
        this.contactHomePhone = contactHomePhone;
    }

    public String getContactLastName() {
        return this.contactLastName;
    }

    public void setContactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
    }

    public String getContactCellCarrier() {
        return this.contactCellCarrier;
    }

    public void setContactCellCarrier(String contactCellCarrier) {
        this.contactCellCarrier = contactCellCarrier;
    }
}

