/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients.view;

import java.io.StringWriter;
import java.util.List;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.service.patient.IPatient;

public class JSONMarkupGenerator {
    public static String markup(IPatient patient) {
        StringBuffer out = new StringBuffer();
        out.append("{'data':");
        out.append("{");
        out.append("'fields':");
        out.append("['PatientId', 'LastName', 'FirstName', 'Address1', 'Address2', 'DateOfBirth'],");
        out.append("'readings':[");
        out.append("{'PatientId': '" + patient.getId() + "', ");
        out.append("'LastName': '" + patient.getLastName() + "', ");
        out.append("'FirstName': '" + patient.getFirstName() + "',");
        out.append("'Address1': '" + patient.getAddressLine1() + "',");
        out.append("'Address2': '" + patient.getAddressLine2() + "', ");
        out.append("'DateOfBirth': '" + patient.getDateOfBirth() + "'}");
        out.append("]");
        out.append("}};");
        return out.toString();
    }

    public static String markup(List patientList) {
        StringWriter out = new StringWriter();
        out.write("{'data':");
        out.write("{");
        out.write("'fields':");
        out.write("['PatientId', 'LastName', 'FirstName'],");
        out.write("'readings':[");
        int i = 0;
        while (i < patientList.size()) {
            Patient patient = (Patient)patientList.get(i);
            out.write("{'PatientId': '" + patient.getId() + "', ");
            out.write("'LastName': '" + patient.getLastName() + "', ");
            out.write("'FirstName': '" + patient.getFirstName() + "'}");
            if (i == patientList.size() - 1) {
                out.write("");
            } else {
                out.write(",");
            }
            ++i;
        }
        out.write("]");
        out.write("}}");
        return out.toString();
    }
}

