/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.patients.view;

import java.io.IOException;
import java.sql.Date;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.patients.view.PatientMarkupGenerator;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.patient.IPatient;
import org.eclipse.soda.stepstone.backend.service.patient.IPatientService;

public class PatientServlet
extends HttpServlet {
    private IPatientService patientService;
    private IDatabaseService dbService;
    private static final long serialVersionUID = 1L;
    private PatientMarkupGenerator markupGenerator = new PatientMarkupGenerator();

    public void bind(IDatabaseService dbService, IPatientService patientService) {
        this.patientService = patientService;
        this.dbService = dbService;
    }

    public void unbind() {
        this.patientService = null;
        this.dbService = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String patientId = request.getPathInfo().substring(1);
            IPatient patient = null;
            try {
                patient = this.patientService.getPatientWithId(patientId);
            }
            catch (StepstoneDatabaseException e) {
                LogUtility.logError((Object)((Object)this), (String)"Error retrieving patient", (Throwable)e);
            }
            if (patient != null) {
                request.setAttribute("patient", (Object)patient);
                RequestDispatcher addPatientDispatcher = this.getServletContext().getRequestDispatcher("/patient/webFiles/patient.jsp");
                addPatientDispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(404, "patient with ID=" + patientId + " does not exist");
            }
            return;
        }
        try {
            List<IPatient> patientList = Arrays.asList(this.patientService.getAllPatients());
            String mimeType = this.getMIMEType(request);
            response.getWriter().print(this.markupGenerator.markup(mimeType, patientList));
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logError((Object)((Object)this), (String)"Error retrieving patients", (Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            try {
                if (this.patientService.getPatientWithId(req.getParameter("PATIENT_ID")) != null) {
                    Patient patient = new Patient();
                    patient.setId(req.getParameter("PATIENT_ID"));
                    patient.setFirstName(req.getParameter("FIRST_NAME"));
                    patient.setLastName(req.getParameter("LAST_NAME"));
                    patient.setAddressLine1(req.getParameter("address1"));
                    patient.setAddressLine2(req.getParameter("address2"));
                    patient.setDateOfBirth(this.makeDate(Integer.parseInt(req.getParameter("year")), Integer.parseInt(req.getParameter("month")), Integer.parseInt(req.getParameter("day"))));
                    if (req.getParameter("MALE").equals("true")) {
                        patient.setIsMale(true);
                    } else {
                        patient.setIsMale(false);
                    }
                    patient.setEthnicity(req.getParameter("ETHICITY"));
                    patient.setContactFirstName(req.getParameter("CONTACT_FIRST_NAME"));
                    patient.setContactLastName(req.getParameter("CONTACT_LAST_NAME"));
                    patient.setContactHomePhone(this.strip(req.getParameter("CONTACT_PHONE")));
                    patient.setContactCellPhone(this.strip(req.getParameter("CONTACT_CELL")));
                    patient.setContactCellCarrier(req.getParameter("CONTACT_CELL_CARRIER"));
                    IDatabaseConnection conn = this.dbService.getDatabaseConnection();
                    patient.updateInDatabase(conn);
                    conn.cleanUp();
                } else {
                    resp.sendError(404, "Patient " + req.getParameter("PATIENT_ID") + " not found");
                }
            }
            catch (StepstoneDatabaseException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            try {
                Patient newPatient = new Patient();
                newPatient.setId(req.getParameter("PATIENT_ID"));
                newPatient.setFirstName(req.getParameter("FIRST_NAME"));
                newPatient.setLastName(req.getParameter("LAST_NAME"));
                newPatient.setAddressLine1(req.getParameter("address1"));
                newPatient.setAddressLine2(req.getParameter("address2"));
                newPatient.setDateOfBirth(this.makeDate(Integer.parseInt(req.getParameter("year")), Integer.parseInt(req.getParameter("month")), Integer.parseInt(req.getParameter("day"))));
                if (req.getParameter("MALE").equals("true")) {
                    newPatient.setIsMale(true);
                } else {
                    newPatient.setIsMale(false);
                }
                newPatient.setEthnicity(req.getParameter("ETHICITY"));
                newPatient.setContactFirstName(req.getParameter("CONTACT_FIRST_NAME"));
                newPatient.setContactLastName(req.getParameter("CONTACT_LAST_NAME"));
                newPatient.setContactHomePhone(this.strip(req.getParameter("CONTACT_PHONE")));
                newPatient.setContactCellPhone(this.strip(req.getParameter("CONTACT_CELL")));
                newPatient.setContactCellCarrier(req.getParameter("CONTACT_CELL_CARRIER"));
                IDatabaseConnection conn = this.dbService.getDatabaseConnection();
                newPatient.writeToDatabase(conn);
                conn.cleanUp();
                response.setStatus(201);
                response.setHeader("Location", req.getRequestURL() + "/" + newPatient.getId());
            }
            catch (StepstoneDatabaseException e) {
                throw new ServletException((Throwable)e);
            }
        }
        String patientId = req.getPathInfo().substring(1);
        Patient patient = null;
        try {
            String newValue;
            String field;
            patient = (Patient)this.patientService.getPatientWithId(patientId);
            if (patient != null && (field = req.getParameter("field")) != null & (newValue = req.getParameter("value")) != null) {
                if (field.equals("LastName")) {
                    patient.setLastName(newValue);
                } else if (field.equals("FirstName")) {
                    patient.setFirstName(newValue);
                } else if (field.equals("Address1")) {
                    patient.setAddressLine1(newValue);
                } else if (field.equals("Address2")) {
                    patient.setAddressLine2(newValue);
                } else if (field.equals("DateOfBirth")) {
                    Date date = this.makeDate(1985, 1, 1);
                    patient.setDateOfBirth(date);
                } else if (field.equals("Gender")) {
                    if (newValue.equals("male")) {
                        patient.setIsMale(true);
                    } else {
                        patient.setIsMale(false);
                    }
                } else if (field.equals("Ethnicity")) {
                    patient.setEthnicity(newValue);
                } else if (field.equals("ContactLastName")) {
                    patient.setContactLastName(newValue);
                } else if (field.equals("ContactFirstName")) {
                    patient.setContactFirstName(newValue);
                } else if (field.equals("ContactCellCarrier")) {
                    patient.setContactCellCarrier(newValue);
                } else if (field.equals("ContactCellPhone")) {
                    patient.setContactCellPhone(newValue);
                } else if (field.equals("ContactHomePhone")) {
                    patient.setContactHomePhone(newValue);
                }
                patient.updateInDatabase(this.dbService.getDatabaseConnection());
            }
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logError((Object)((Object)this), (String)"Error retrieving patient", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            String patientId = pathInfo.substring(1);
            IPatient patient = null;
            try {
                patient = this.patientService.getPatientWithId(patientId);
                if (patient != null) {
                    this.patientService.deletePatientWithId(patientId);
                    return;
                }
                response.sendError(404, "Patient " + patientId + " not found");
            }
            catch (StepstoneDatabaseException e) {
                LogUtility.logError((Object)((Object)this), (String)"Error retrieving patient", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            response.sendError(403);
        }
    }

    private Date makeDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return new Date(cal.getTimeInMillis());
    }

    private String strip(String string) {
        String returnString = "";
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                returnString = String.valueOf(returnString) + c;
            }
            ++i;
        }
        return returnString;
    }

    protected String getMIMEType(HttpServletRequest request) {
        if (request.getHeader("Accept").equals("application/json")) {
            return "application/json";
        }
        return "text/html";
    }
}

