/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.services.database.derby;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.service.database.CallbackRegistry;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.PrimaryKey;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.database.StringWithLength;

public class DerbyConnection
implements IDatabaseConnection {
    private static String SQL_DRIVER = "jdbc:derby";
    private static Map instanceTable = new HashMap();
    private Connection connection;
    private String dbName;
    private CallbackRegistry callbacks = new CallbackRegistry();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public static synchronized DerbyConnection getConnectionInstance(String dbName) {
        if (instanceTable.containsKey(dbName)) {
            return (DerbyConnection)instanceTable.get(dbName);
        }
        DerbyConnection newConnection = null;
        try {
            newConnection = new DerbyConnection(dbName);
        }
        catch (SQLException e) {
            LogUtility.logWarning((String)"Problem getting Derby connection", (Throwable)e);
        }
        instanceTable.put(dbName, newConnection);
        return newConnection;
    }

    private DerbyConnection(String dbName) throws SQLException {
        Properties props = new Properties();
        this.dbName = dbName;
        this.connection = DriverManager.getConnection(String.valueOf(SQL_DRIVER) + ":" + dbName, props);
    }

    public void cleanUp() throws StepstoneDatabaseException {
    }

    public boolean tableExists(String tableName) throws StepstoneDatabaseException {
        block2: {
            try {
                Statement st = this.connection.createStatement();
                st.executeQuery("SELECT * FROM " + tableName);
                st.close();
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("42X05")) break block2;
                return false;
            }
        }
        return true;
    }

    private String getTypeString(Object type) throws StepstoneDatabaseException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return "TIMESTAMP";
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2 || type == Integer.TYPE) {
            return "INTEGER";
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return "SMALLINT";
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return "DOUBLE";
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return "VARCHAR(" + new Integer(Integer.MAX_VALUE).toString() + ")";
        }
        if (type instanceof StringWithLength) {
            return "VARCHAR(" + new Integer(((StringWithLength)type).getLength()).toString() + ")";
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz6) {
            return "DATE";
        }
        if (type instanceof PrimaryKey) {
            return String.valueOf(this.getTypeString(((PrimaryKey)type).getType())) + " PRIMARY KEY";
        }
        throw new StepstoneDatabaseException(String.valueOf(type.toString()) + "Type not supported");
    }

    public void createTable(String tableName, String[] fields, Object[] types) throws StepstoneDatabaseException {
        String queryString = "CREATE TABLE " + tableName + "(";
        if (fields.length != types.length) {
            throw new StepstoneDatabaseException("fields and types sizes do not match");
        }
        int i = 0;
        while (i < fields.length) {
            queryString = String.valueOf(queryString) + fields[i] + " " + this.getTypeString(types[i]);
            if (i != fields.length - 1) {
                queryString = String.valueOf(queryString) + ", ";
            }
            ++i;
        }
        queryString = String.valueOf(queryString) + ")";
        try {
            Statement st = this.connection.createStatement();
            st.executeUpdate(queryString);
            st.close();
        }
        catch (SQLException e) {
            throw new StepstoneDatabaseException((Throwable)e);
        }
    }

    private String[] getFields(String tableName) throws SQLException {
        ResultSet columnRS = this.connection.getMetaData().getColumns(null, null, tableName.toUpperCase(), null);
        ArrayList<String> columnList = new ArrayList<String>();
        while (columnRS.next()) {
            columnList.add(columnRS.getString("COLUMN_NAME"));
        }
        columnRS.close();
        return columnList.toArray(new String[0]);
    }

    private String getFieldsSingleString(String[] fields) {
        String str = "";
        int i = 0;
        while (i < fields.length) {
            str = String.valueOf(str) + fields[i];
            if (i != fields.length - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str;
    }

    public List getReadings(String tableName, String queryField, Object queryValue, String orderField) throws StepstoneDatabaseException {
        return this.getReadings(tableName, queryField, queryValue, orderField, 0);
    }

    public List getReadings(String tableName, String queryField, Object queryValue, String orderField, int maxRecords) throws StepstoneDatabaseException {
        try {
            String[] fields = this.getFields(tableName);
            String query = "SELECT " + this.getFieldsSingleString(fields) + " FROM " + tableName;
            if (queryField != null) {
                query = String.valueOf(query) + " WHERE " + queryField + " = " + this.convertToQueryString(queryValue);
            }
            if (orderField != null) {
                query = String.valueOf(query) + " ORDER BY " + orderField;
            }
            List resultList = null;
            Statement st = this.connection.createStatement();
            ResultSet results = st.executeQuery(query);
            resultList = new ArrayList();
            while (results.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                int i = 0;
                while (i < fields.length) {
                    result.put(fields[i], results.getObject(fields[i]));
                    ++i;
                }
                resultList.add(result);
            }
            st.close();
            if (maxRecords > 0 && maxRecords < resultList.size()) {
                resultList = resultList.subList(0, maxRecords);
            }
            return resultList;
        }
        catch (SQLException e) {
            throw new StepstoneDatabaseException((Throwable)e);
        }
    }

    private String convertToQueryString(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Double) {
            DecimalFormat formatter = new DecimalFormat("#.###");
            return formatter.format((Double)value);
        }
        if (value instanceof Timestamp) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof java.util.Date) {
            return "'" + new Date(((java.util.Date)value).getTime()).toString() + "'";
        }
        return "'" + value.toString() + "'";
    }

    public void insertItem(String tableName, Map item) throws StepstoneDatabaseException {
        try {
            String queryString = "INSERT INTO " + tableName + " (";
            Iterator keys = item.keySet().iterator();
            String[] fields = this.getFields(tableName);
            ArrayList<String> fieldIntersection = new ArrayList<String>();
            while (keys.hasNext()) {
                String thisKey = (String)keys.next();
                boolean found = false;
                int i = 0;
                while (i < fields.length && !found) {
                    if (fields[i].equalsIgnoreCase(thisKey)) {
                        fieldIntersection.add(thisKey);
                        found = true;
                    }
                    ++i;
                }
            }
            String[] columns = fieldIntersection.toArray(new String[0]);
            int i = 0;
            while (i < columns.length) {
                queryString = String.valueOf(queryString) + columns[i];
                if (i < columns.length - 1) {
                    queryString = String.valueOf(queryString) + ", ";
                }
                ++i;
            }
            queryString = String.valueOf(queryString) + ") VALUES (";
            i = 0;
            while (i < columns.length) {
                queryString = String.valueOf(queryString) + this.convertToQueryString(item.get(columns[i]));
                if (i < columns.length - 1) {
                    queryString = String.valueOf(queryString) + ", ";
                }
                ++i;
            }
            queryString = String.valueOf(queryString) + ")";
            Statement st = this.connection.createStatement();
            int count = st.executeUpdate(queryString);
            st.close();
            if (count != 1) {
                throw new StepstoneDatabaseException("Error inserting new item into database");
            }
        }
        catch (SQLException e) {
            throw new StepstoneDatabaseException((Throwable)e);
        }
        this.callbacks.invokeCallbacks(tableName, item);
    }

    public void registerCallback(String tableName, Method callbackMethod) {
        this.callbacks.registerCallback(tableName, callbackMethod);
    }

    public int deleteItem(String tableName, String queryField, Object queryValue) throws StepstoneDatabaseException {
        String queryString = "DELETE FROM " + tableName + " WHERE " + queryField + " = " + this.convertToQueryString(queryValue);
        try {
            Statement st = this.connection.createStatement();
            int result = st.executeUpdate(queryString);
            st.close();
            return result;
        }
        catch (SQLException e) {
            throw new StepstoneDatabaseException((Throwable)e);
        }
    }

    public void updateItem(String tableName, Map item, String keyField) throws StepstoneDatabaseException {
        String queryString = "UPDATE " + tableName + " SET ";
        Iterator it = item.keySet().iterator();
        boolean firstKey = true;
        while (it.hasNext()) {
            String thisKey = (String)it.next();
            if (thisKey.equalsIgnoreCase(keyField)) continue;
            if (firstKey) {
                firstKey = false;
            } else {
                queryString = String.valueOf(queryString) + ", ";
            }
            queryString = String.valueOf(queryString) + thisKey + " = " + this.convertToQueryString(item.get(thisKey));
        }
        queryString = String.valueOf(queryString) + " WHERE " + keyField + " = " + this.convertToQueryString(item.get(keyField));
        try {
            Statement st = this.connection.createStatement();
            st.executeUpdate(queryString);
            st.close();
        }
        catch (SQLException e) {
            throw new StepstoneDatabaseException((Throwable)e);
        }
    }
}

