/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.service.database.memory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.service.database.CallbackRegistry;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;

public class MemoryConnection
implements IDatabaseConnection {
    private Map allTables = new HashMap();
    private CallbackRegistry callbacks = new CallbackRegistry();

    public void cleanUp() throws StepstoneDatabaseException {
    }

    protected MemoryConnection(Map initMap) {
        this.allTables = initMap;
    }

    public MemoryConnection() {
    }

    public void createTable(String tableName, String[] fields, Object[] types) throws RuntimeException {
        this.allTables.put(tableName, new ArrayList());
    }

    public int deleteItem(String tableName, String queryField, Object queryValue) {
        List thisTable = (List)this.allTables.get(tableName);
        Iterator it = thisTable.iterator();
        int deleteCount = 0;
        while (it.hasNext()) {
            Map thisRow = (Map)it.next();
            if (!thisRow.containsKey(queryField) || !thisRow.get(queryField).equals(queryValue)) continue;
            ++deleteCount;
            it.remove();
        }
        return deleteCount;
    }

    private List cloneList(List original) {
        return (List)((ArrayList)original).clone();
    }

    public List getReadings(String tableName, String queryField, Object queryValue, String orderField) throws StepstoneDatabaseException {
        return this.getReadings(tableName, queryField, queryValue, orderField, 0);
    }

    public List getReadings(String tableName, String queryField, Object queryValue, String orderField, int maxRecords) throws RuntimeException {
        List<Map> thisTable = (ArrayList)this.allTables.get(tableName);
        if (queryField != null) {
            Iterator it = thisTable.iterator();
            thisTable = new ArrayList();
            while (it.hasNext()) {
                Map thisRow = (Map)it.next();
                if (!thisRow.containsKey(queryField) || !thisRow.get(queryField).equals(queryValue)) continue;
                thisTable.add(thisRow);
            }
        }
        thisTable = this.cloneList(thisTable);
        if (orderField != null) {
            MyComparator c = new MyComparator(orderField);
            Collections.sort(thisTable, c);
        }
        if (maxRecords > 0 && maxRecords < thisTable.size()) {
            thisTable = thisTable.subList(0, maxRecords);
        }
        return thisTable;
    }

    public void insertItem(String tableName, Map item) throws RuntimeException {
        List thisTable = (List)this.allTables.get(tableName);
        thisTable.add(item);
        this.callbacks.invokeCallbacks(tableName, item);
    }

    public void registerCallback(String tableName, Method callbackMethod) {
        this.callbacks.registerCallback(tableName, callbackMethod);
    }

    public boolean tableExists(String tableName) throws StepstoneDatabaseException {
        return this.allTables.containsKey(tableName);
    }

    public void updateItem(String tableName, Map item, String keyField) {
        List thisTable = (List)this.allTables.get(tableName);
        Object keyValue = item.get(keyField);
        Iterator it = thisTable.iterator();
        boolean addItem = false;
        while (it.hasNext()) {
            Map thisRow = (Map)it.next();
            if (!thisRow.containsKey(keyField) || !thisRow.get(keyField).equals(keyValue)) continue;
            addItem = true;
            it.remove();
        }
        if (addItem) {
            thisTable.add(item);
        }
    }

    private class MyComparator
    implements Comparator {
        private String comparisonField;

        public MyComparator(String cf) {
            this.comparisonField = cf;
        }

        public int compare(Object o1, Object o2) {
            Map m1 = (Map)o1;
            Map m2 = (Map)o2;
            return ((Comparable)m1.get(this.comparisonField)).compareTo((Comparable)m2.get(this.comparisonField));
        }
    }
}

