/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.service.database.memory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseConnection;
import org.eclipse.soda.stepstone.backend.service.database.IDatabaseService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.database.memory.MemoryConnection;

public class MemoryDatabaseService
implements IDatabaseService {
    private Map databases = new HashMap();

    public IDatabaseConnection getDatabaseConnection() throws StepstoneDatabaseException {
        return this.getDatabaseConnection("default-database");
    }

    public synchronized IDatabaseConnection getDatabaseConnection(String databaseName) throws StepstoneDatabaseException {
        if (this.databases.containsKey(databaseName)) {
            return (IDatabaseConnection)this.databases.get(databaseName);
        }
        MemoryConnection newDB = new MemoryConnection();
        this.databases.put(databaseName, newDB);
        return newDB;
    }

    public void initializeDatabase(String databaseName, Map tables) {
        this.databases.put(databaseName, new MemoryConnection(tables));
    }
}

