/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.service.database;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.sat.core.util.LogUtility;

public class CallbackRegistry {
    private Map callbacks = new HashMap();

    public void registerCallback(String tableName, Method callbackMethod) {
        List<Method> callbackList;
        if (this.callbacks.containsKey(tableName)) {
            callbackList = (List)this.callbacks.get(tableName);
        } else {
            callbackList = new ArrayList();
            this.callbacks.put(tableName, callbackList);
        }
        callbackList.add(callbackMethod);
    }

    public int invokeCallbacks(String tableName, Map newItem) {
        List callbackList = (List)this.callbacks.get(tableName);
        if (callbackList != null) {
            Iterator it = callbackList.iterator();
            while (it.hasNext()) {
                Method callback = (Method)it.next();
                try {
                    callback.invoke(null, newItem);
                }
                catch (IllegalAccessException e) {
                    LogUtility.logWarning((String)"Problem with database callback", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LogUtility.logWarning((String)"Problem with database callback", (Throwable)e);
                }
            }
            return callbackList.size();
        }
        return 0;
    }
}

