/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.backend.ui;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.backend.common.global.IGlobalStoreService;
import org.eclipse.soda.stepstone.backend.patients.model.Patient;
import org.eclipse.soda.stepstone.backend.patients.service.IPatientService;
import org.eclipse.soda.stepstone.backend.service.database.StepstoneDatabaseException;
import org.eclipse.soda.stepstone.backend.service.device.IDeviceService;
import org.eclipse.soda.stepstone.backend.service.uiregistry.IUIExtensionRegistry;

public class StepstoneServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private IDeviceService deviceService;
    private IUIExtensionRegistry extensionRegistry;
    private IGlobalStoreService globalStoreService;
    private IPatientService patientService;

    public void bind(IDeviceService deviceService, IUIExtensionRegistry extensionRegistry, IGlobalStoreService globalStoreService, IPatientService patientService) {
        this.deviceService = deviceService;
        this.extensionRegistry = extensionRegistry;
        this.globalStoreService = globalStoreService;
        this.patientService = patientService;
    }

    public void unbind() {
        this.deviceService = null;
        this.extensionRegistry = null;
        this.globalStoreService = null;
        this.patientService = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = req.getParameter("url");
        if (url != null) {
            if (req.getParameter("url").equals("clear-patient")) {
                req.setAttribute("url", (Object)"");
                if (this.globalStoreService.get("currentPatient") != null) {
                    this.globalStoreService.put("currentPatient", null);
                }
            } else {
                req.setAttribute("url", (Object)url);
            }
        } else {
            req.setAttribute("url", (Object)"");
        }
        req.setAttribute("extensions", (Object)this.extensionRegistry.getAllExtensions());
        req.setAttribute("components", (Object)this.deviceService.getDataComponents());
        req.setAttribute("utilities", (Object)this.extensionRegistry.getAllUtilities());
        String patientId = (String)this.globalStoreService.get("currentPatient");
        try {
            if (patientId == null) {
                req.setAttribute("patientSelected", (Object)new Boolean(false));
                req.setAttribute("currentPatient", (Object)new Patient());
            } else {
                Patient currentPatient = this.patientService.getPatientWithId(patientId);
                req.setAttribute("patientSelected", (Object)new Boolean(true));
                req.setAttribute("currentPatient", (Object)currentPatient);
            }
        }
        catch (StepstoneDatabaseException e) {
            LogUtility.logDebug((String)"Error while fetching patient", (Throwable)e);
        }
        RequestDispatcher dispatcher = req.getRequestDispatcher("index.jsp");
        dispatcher.include((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

