<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title>Stepstone Communications Servlet</title>
	<script src="formHelper.js"></script>
	<script type="text/javascript">
	function load(){
		var now = new Date();
		setDate(now.getFullYear(),now.getMonth()+1,now.getDate());
		if(now >= Date.UTC(now)){
			setTime(now.getHours(), now.getMinutes(), now.getSeconds(), "+", now.getHours() - now.getUTCHours(),
					now.getMinutes - now.getUTCMinutes());
		}
		else{
			setTime(now.getHours(), now.getMinutes(), now.getSeconds(), "-", now.getUTCHours() - now.getHours(),
					now.getUTCMinutes() - now.getMinutes());
		}
		showForm();
	}
	function showForm(){
		if (document.getElementById("parameter-name").value == "blood-pressure"){
			document.getElementById("weightReading").style.display="none";
			document.getElementById("bpReading").style.display="block";
			document.getElementById("parameter-value").value = "110|80|72";
		}
		else if (document.getElementById("parameter-name").value == "weight"){
			document.getElementById("bpReading").style.display="none";
			document.getElementById("weightReading").style.display="block";
			document.getElementById("parameter-value").value = "72.27";
		}
		else if (document.getElementById("parameter-name").value == "pulse-oximeter"){
			document.getElementById("bpReading").style.display="none";
			document.getElementById("weightReading").style.display="block";
			document.getElementById("parameter-value").value = "800|72";
		}
		else if (document.getElementById("parameter-name").value == "temperature"){
			document.getElementById("bpReading").style.display="none";
			document.getElementById("weightReading").style.display="block";
			document.getElementById("parameter-value").value = "32";
		}
		else{
			alert("please choose a reading type");
		}
	}
	function checkForm(){
		var passed = true;
		if (!checkId()) passed = false;
		if (!checkDate()) passed = false;
		if (!checkReading()) passed = false;
		if(document.getElementById("parameter-name").value == "weight"){
			document.getElementById("parameter-value").value = 
					Math.round(100 * document.getElementById("parameter-value").value);
		}
		return passed;
	}
	</script>
</head>
<body onload="load()">
	<h1>Welcome to the Stepstone Communications Servlet</h1>
	<p>Under Construction</p>

	<form id="readingForm" name="readingForm" action="/stepstone/communications" method="post" onsubmit="return checkForm()">
		<label for="unit-id">Patient Id</label> 
		<input id="unit-id" name="unit-id" type="text" value="12AB78" /> 
		
		<div id="date">
			<label for="date">Date (MM/dd/yyyy)</label>
			<input id="month" name="month" type="text"  size="2" maxlength="2" /> /
			<input id="day" name="day" type="text"  size="2" maxlength="2" /> /
			<input id="year" name="year" type="text"  size="4" maxlength="4" />
		</div>
		
		<label for="time">Time (hh:mm:ss[+-]hh:mm)</label>
		<div id="time">
			<input id="hours" name="hours" type="text"  size="2" maxlength="2" /> :
			<input id="minutes" name="minutes" type="text"  size="2" maxlength="2" /> : 
			<input id="seconds" name="seconds" type="text"  size="2" maxlength="2" />
			<input id="sign" name="sign" type="text"  size="1" maxlength="1" />
			<input id="hoursOffset" name="hoursOffset" type="text"  size="2" maxlength="2" /> :
			<input id="minutesOffset" name="minutesOffset" type="text"  size="2" maxlength="2" />
		</div>
		
		<select id="parameter-name" name="parameter-name" onchange="showForm()">
			<option value="blood-pressure" selected="selected">Blood Pressure</option>
			<option value="weight">Weight</option>
			<option value="pulse-oximeter">Pulse Oximter</option>
			<option value="temperature">Temperature</option>
		</select>
		
		<!-- TODO dynamically get reading types from the database -->
		<div id="bpReading" class="reading" style="display: none">
		<label for="bpReading">Blood Pressure (systolic|diastolic|heartrate)</label>
		<!--
		<label for="systolic">systolic</label>
		<input id="systolic" type="text" value="110" />
		
		<label for="diastolic">diastolic</label>
		<input id="diastolic" type="text" value="80" />
		
		<label for="heartrate">heartrate</label>
		<input id="heartrate" type="text" value="72" />
		-->
		</div>
		
		<div id="weightReading" class="reading" style="display: none">
		<label for="weightReading">Weight (kg)</label>
		<!--  
		<label for="weight">weight in decagrams (kg/100)</label>
		<input id="weight" type="text" value="7227" />
		-->
		</div>
		
		<div id="temperatureReading" class="reading" style="display:none">
		<label for="temperatureReading">Temperature (C)</label>
		</div>
		
		<div id="pulseoxReading" class="reading" style="display:none">
		<label for="pulseoxReading">Pulse Oximeter (pleth|heartrate)</label>
		</div>
		
		<input id="parameter-value" name="parameter-value" type="text" value="110,80,72" />
		
		<input type="submit" value="Submit Reading"/>
	</form>
</body>
</html>