/**
 * JavaScript helper methods for Stepstone
 */

//The following are methods for setting default values
function setDate(year, month, day){
	document.getElementById("year").value = numToString(year, 4);
	document.getElementById("month").value = numToString(month, 2);
	document.getElementById("day").value = 	numToString(day, 2);
}
function setTime(hours,minutes,seconds,sign,hoursOffset,minutesOffset){
	document.getElementById("hours").value = numToString(hours, 2);
	document.getElementById("minutes").value = numToString(minutes, 2);
	document.getElementById("seconds").value = numToString(seconds, 2);
	document.getElementById("sign").value = sign;
	document.getElementById("hoursOffset").value = 	numToString(hoursOffset, 2);
	document.getElementById("minutesOffset").value = numToString(minutesOffset, 2);
}

//The following are validation functions for forms
function checkId(patientId){
	if(document.getElementById("unit-id").value.length > 0){
		return true;
	}
	alert("The patient Id value cannot be empty");
	return false;
}
function checkDate(){
	var readingDate = new Date();
	var today = new Date();
	var year = document.getElementById("year").value;
	var month = document.getElementById("month").value - 1;
	var day = document.getElementById("day").value;
	readingDate.setFullYear(year,month,day);
	if(year!=null && month!=null && day!=null && month >= 0 && month < 12 && day > 0 && 
					day < 32 && readingDate <= today){
		return true;
	}
	else{
		alert("Please enter a valid date");
	}
	return false;
}
function checkReading(){
	//TODO check specific readings?
	if(document.getElementById("parameter-value").value.length > 0){
		return true;
	}
	alert("The reading value cannot be empty");
	return false;
}

//The following are helper methods for working with and displaying numbers and strings
/*Adds "0" prefix to number until it is desired length*/
function numToString(num,length){
	var numString = new String(num);
	while(numString.length < length){
		numString = "0" + numString;
	}
	return numString;
}