<%@ page import="org.eclipse.soda.stepstone.backend.service.device.IDataComponent" %>
<%@ page import="org.eclipse.soda.stepstone.backend.service.uiregistry.IUIExtension" %>
<%@ page import="org.eclipse.soda.stepstone.backend.patients.model.Patient" %>

<jsp:useBean id="extensions" type="IUIExtension[]" scope="request"></jsp:useBean>
<jsp:useBean id="components" type="IDataComponent[]" scope="request"></jsp:useBean>
<jsp:useBean id="utilities" type="IUIExtension[]" scope="request"></jsp:useBean>
<jsp:useBean id="patientSelected" type="Boolean" scope="request"></jsp:useBean>
<jsp:useBean id="currentPatient" type="Patient" scope="request"></jsp:useBean>
<jsp:useBean id="url" type="java.lang.String" scope="request"></jsp:useBean>
	
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en-AU">
  <head>
    <title>Stepstone</title>
    <script type="text/javascript" src="http://o.aolcdn.com/dojo/1.1.1/dojo/dojo.xd.js" djConfig="parseOnLoad: true"></script>
    <script type="text/javascript" src="http://o.aolcdn.com/dojo/1.1.1/dojox/gfx.js"></script>
    <style type="text/css">
		@import "http://o.aolcdn.com/dojo/1.1.1/dijit/themes/tundra/tundra.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dojo/resources/dojo.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dijit/tests/css/dijitTests.css";
		@import "http://o.aolcdn.com/dojo/1.1.1/dojox/grid/_grid/tundraGrid.css";
	</style>

	<!-- Use something like this for local debugging via firebug -->
    <!-- <script type="text/javascript" src="<%=request.getContextPath()%>/dojo/dojo.js" djConfig="debugAtAllCost: true, isDebug: true, parseOnLoad: true"></script>
    <script type="text/javascript" src="<%=request.getContextPath()%>/dojox/gfx.js"></script>
    <style type="text/css">
		@import "/dijit/themes/tundra/tundra.css";
		@import "/dojo/resources/dojo.css";
		@import "/dijit/tests/css/dijitTests.css";
		@import "/dojox/grid/_grid/tundraGrid.css";
	</style> 
    -->
    
    <script type="text/javascript">	
		dojo.require("dojo.parser");

		dojo.require("dijit.layout.BorderContainer");
		dojo.require("dijit.layout.AccordionContainer");
		dojo.require("dijit.layout.TabContainer");
		dojo.require("dijit.layout.ContentPane");
		
		dojo.require("dojox.data.HtmlTableStore");
		dojo.require("dojox.grid.Grid");
		dojo.require("dojox.charting.widget.Chart2D");
		
		function hideLoader(){
			var loader = dojo.byId('loader');
			loader.style.display = "none";
		}
		function resizeGrid(){
			var grid = dijit.byId("readingTable");
			if(grid) grid.resize();
		}
		
		
    	
		dojo.addOnLoad(function(){
			var nl = dojo.query(".dojoxGrid-scrollbox");
        	dojo.forEach(nl, function (n) { n.style.overflow = "auto"; });
			
			hideLoader();
			setTimeout("resizeGrid()",10);
		});
    </script>
  </head>

  <body class="tundra">
  
  <!-- basic preloader: -->
  <div id="loader"></div>
  <script type="text/javascript">
   	/* pre-loader specific stuff to prevent unsightly flash of unstyled content */
   		var loader = document.getElementById("loader");
   		loader.style.padding=0;
   		loader.style.margin=0;
   		loader.style.position="absolute";
   		loader.style.top=0;
   		loader.style.left=0;
   		loader.style.width="100%";
   		loader.style.height="100%";
   		loader.style.background="#ededed";
   		loader.style.zIndex=999;
   		loader.style.verticalAlign="center";
  </script>

  
  <div dojotype="dijit.layout.BorderContainer" style="width: 100%; height: 100%;">

    <!-- ##### Header ##### -->
    <div id="header" dojoType="dijit.layout.ContentPane" region="top">
      <div class="superHeader" style="float: right;">
          <span class="doNotDisplay">Related sites:</span>
          	<% for (int i = 0; i < extensions.length; i++) { %>
			<a href="<%=extensions[i].getURL()%>" target="_top">
				<%=extensions[i].getTitle()%></a>
			<%}%>
      </div>

      <div class="midHeader">
        <h1 class="headerTitle" style="margin-top: 0">Stepstone</h1>
      </div>

      <div class="subHeader">
      	<b>Health Monitor Practitioner Portal</b>
      </div>
      <hr />
    </div>

    <!-- ##### Side Bar ##### -->    
    <div id="side-bar" dojoType="dijit.layout.AccordionContainer" region="leading" splitter="true" style="width: 200px;">
    	<div dojoType="dijit.layout.AccordionPane" title="Devices">
	        <ul>
		  <% for (int i = 0; i < components.length; i++) { %>
				<li><a href="index?url=<%=components[i].getServletTag()%>">
					<%=components[i].getDeviceName() %> </a></li>
		  <%}%>
	        </ul>
	    </div>
		<div dojoType="dijit.layout.AccordionPane" title="Patient">
	        <span class="sideBarText">
	        	<%
	        		if (patientSelected.booleanValue()){
	        			out.print(currentPatient.getFullName());
	        			out.print("<a href=\"index?url=clear-patient\">" +
	        					"Clear patient selection</a>");
	        		}
	        		else{
	        			out.print("No patient selected");
	        		}
	        	%>
	        	<br>
	        	<a href="index?url=patient-servlet">Select another
	        	patient</a><br>
	        </span>
	    </div>
	    <% if (utilities != null && utilities.length > 0) { %>
	      <div dojoType="dijit.layout.AccordionPane" title="Utilities">
	      <ul>
	          	<% for (int i = 0; i < utilities.length; i++) { %>
				<li>
				<a href="<%=utilities[i].getURL()%>">
					<%=utilities[i].getTitle()%></a>
				</li>
			<%}%>
	      </ul>
	    </div>
	    <% } %>
	</div>  <!-- end of Accordion -->

    <!-- ##### Main Copy ##### -->
    <div id="main-copy" dojoType="dijit.layout.ContentPane" region="center">
    	<% if (url != null && url != "") { %>
			<jsp:include page="<%=url%>" flush="true"/>
		<% } %>
    </div>

	<!-- ##### Footer ##### -->
    <div id="footer" dojoType="dijit.layout.ContentPane" region="bottom">
    	<hr />
Credits:  <a href="http://www.eclipse.org/ohf/">Eclipse OHF</a>,
          <a href="http://sensorplatform.org">SODA</a>
    </div>
  </div>
  </body>
</html>
