/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
dojo.provide("stepstone.AddPatientDialog");

dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.Textarea");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.DateTextBox");
dojo.require("dijit.form.TimeTextBox");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.CheckBox");

dojo.declare("stepstone.AddPatientDialog", [dijit.Dialog], 
{
	title: "Add Patient",
	
	widgetsInTemplate: true,
	
	//override the templateString
	templateString: "",
	
	templatePath: dojo.moduleUrl("stepstone","resources/AddPatientDialog.html"),
	
	postCreate: function(){
		//dojo.connect(this.submitButton,"onclick",this.submit);
		this.inherited(arguments);
	},
	
	checkForm: function(){
		debugger;
		var today = new Date();
		var dob = new Date();
		var year = document.getElementById("year").value;
		var month = document.getElementById("month").value - 1;
		var day = document.getElementById("day").value;
		
		dob.setFullYear(year,month,day);
		if(document.getElementById("id").value.length > 0){
			if(year!=null && month!=null && day!=null && month >= 0 && month < 12 && day > 0 && day < 32 && dob < today){
				return true;
			}
			else{
				alert("Please enter a valid date of birth");
			}
		}
		else{
			alert("The patient Id value cannot be empty");
		}
		return false;
	},
	
	/**
	* Submit new patient request.
	*/
	execute: function(contents) 
	{
		var params = {
				url: "patients",
				content: contents
		}
		dojo.xhrPost(params);
	}
});
