/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
dojo.provide("stepstone.DeviceDataWidget");
dojo.require("dijit.TitlePane");
dojo.require("dijit.form.Textarea");
dojo.require("dojo.data.ItemFileWriteStore");
dojo.require("dojox.data.jsonPathStore");
dojo.require("dojox.data.CsvStore");
dojo.require("dojox.grid.Grid");
dojo.declare("stepstone.DeviceDataWidget", [dijit.TitlePane], 
{
	// dataFeedUrl: String
	//	URL of the data feed
	dataFeedUrl: "",
	
	widgetsInTemplate: true,
	
	//override the templateString
	templateString: "",
	
	templatePath: dojo.moduleUrl("stepstone","resources/DeviceDataWidget.html"),
	
	//overwrite default FloatingPane attributes
	closable:false,
	maxable:false,
	resizable:true,
	dockable:true,
	dockTo:"alternateDock",
	
	inputType:"json",
	
	postCreate: function(){
		this.inherited(arguments);
		
		var fieldList;
		var readingList;
		if (this.inputType == "json"){
			//get JSON data
			var jsonData = this.getJsonData(this.dataFeedUrl);
	
			//store field and reading data
			fieldList = jsonData.results[0].data.fields;
			readingList = jsonData.results[0].data.readings;
		
			//pass reading data to store
			this.store = new dojox.data.jsonPathStore({data: readingList});
			//var store = new dojox.data.jsonPathStore({url: dataFeedUrl});
		}else if (this.inputType == "csv"){ 
			var csvData = this.getCsvData(this.dataFeedUrl);
			this.store = new dojox.data.CsvStore({
				data: csvData.results[0]
			});
			//store = new dojox.data.CsvStore({
			//	url: this.dataFeedUrl
			//});
			var item = this.store.fetchItemByIdentity({identity:0});
			//store.fetch({query:{Date:"*"}});
			
			//FIXME using internal Store API
			fieldList = store._attributes;
		}else{
			alert("content type " + this.inputType + " not yet supported");
		} 

		//pass store to dojo data to allow dojo data to be used with Grid
		var model = new dojox.grid.data.DojoData(null, this.store, {clientSort: true, query: {}});
	
		//set the view on the layout
		var layout = [this.createView(fieldList)];
			
		this.grid = new dojox.Grid({"structure": layout, "model": model}, this.dataGrid);
		this.grid.render();
		this.startup();
	},
	
	/**
	* Use field data to create objects for the view so that column names are dynamically updated.
	*/
	createView: function(fieldList) 
	{
		var i;
		var view = new Object();
		var cellsArray = new Array();
		cellsArray[0] = new Array();
		
		for(i in fieldList) {
			var field = new Object();
			field.name = fieldList[i];
			cellsArray[0][i] = field;
		}
		view.cells = cellsArray;
		return view;
	},
	
	/**
	* Submit request to get json data
	*/
	getJsonData: function(url) 
	{
		//specify paramaters for xhrGet request of data
		var params = {
				sync: true,
				url: url,
				headers:{Accept:"application/json"}, //ask for JSON data to be returned
				handleAs: "json"
		}
		//return json response
		if(url)
			return dojo.xhrGet(params);
		else
			console.log("Data URL Required for DeviceDataWidget");
	},
	
	/**
	* Submit request to get csv data
	*/
	getCsvData: function(url) 
	{
		//specify paramaters for xhrGet request of data
		var params = {
				sync: true,
				url: url,
				headers:{Accept:"text/csv"}, //ask for Csv data to be returned
				handleAs: "text"
		}
		//return json response
		if(url)
			return dojo.xhrGet(params);
		else
			console.log("Data URL Required for DeviceDataWidget");
	},
	
	filter: function(jsonPath)
	{
		this.grid.model.query = jsonPath;
		this.grid.model.requestRows();
		this.grid.render();
	},
	
	/**
	* change the dataFeedUrl
	*/
	updateUrl: function(newUrl) 
	{
		debugger;
		console.log("Updating Url to " + newUrl);
		this.dataFeedUrl = newUrl;
		//get JSON data
		var jsonData = this.getJsonData(this.dataFeedUrl);

		//store field and reading data
		var fieldList = jsonData.results[0].data.fields;
		var readingList = jsonData.results[0].data.readings;
	
		//pass reading data to store
		var store = new dojox.data.jsonPathStore({"data": readingList});
	
		//pass store to dojo data to allow dojo data to be used with Grid
		var model = new dojox.grid.data.DojoData(null, store, {"clientSort": true, "query": {}});

		this.grid.setModel(model);
		this.grid.render();
	}
});
