/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
dojo.provide("stepstone.PatientList");

dojo.require("dijit.layout.ContentPane");
dojo.require("dojo.data.ItemFileWriteStore");
dojo.require("dojox.data.jsonPathStore");
dojo.require("dojox.grid.Grid");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.Form");
dojo.require("dijit.form.SimpleTextarea");
dojo.require("dijit.form.Button");
dojo.require("stepstone.AddPatientDialog");

dojo.declare("stepstone.PatientList", [ dijit._Widget, dijit._Templated ], 
{
	//default url to the patient service
	url: "patients",
	
	widgetsInTemplate: true,
	
	//override the templateString
	templateString: "",
	
	templatePath: dojo.moduleUrl("stepstone","resources/PatientList.html"),
	
	inputType: "json",
	
	postCreate: function(){
		//this.inherited(arguments);
		
		var store;
		var fieldList;
		var readingList;
		if (this.inputType == "json"){
			//get JSON data
			var jsonData = this.getJsonData(this.url);
	
			//store field and reading data
			fieldList = jsonData.results[0].data.fields;
			readingList = jsonData.results[0].data.readings;
		
			//pass reading data to store
			store = new dojox.data.jsonPathStore({data: readingList});
			//var store = new dojox.data.jsonPathStore({url: dataFeedUrl});
		}else{
			alert("content type " + inputType + " not supported");
		} 

		//pass store to dojo data to allow dojo data to be used with Grid
		var model = new dojox.grid.data.DojoData(null, store, {clientSort: true, query: {}});
	
		//set the view on the layout
		var layout = [this.createView(fieldList)];
			
		this.grid = new dojox.Grid({"structure": layout, "model": model}, this.patientList);
		this.grid.selection.multiSelect = false;
		this.grid.render();
		
		this.startup();
	},
	
	/**
	* Use field data to create objects for the view so that column names are dynamically updated.
	*/
	createView: function(fieldList) 
	{
		/*var i;
		var view = new Object();
		var cellsArray = new Array();
		cellsArray[0] = new Array();
		
		for(i in fieldList) {
			var field = new Object();
			field.name = fieldList[i];
			cellsArray[0][i] = field;
		}
		view.cells = cellsArray;
		return view;*/
		
		var layout = {
			defaultCell: { width: 8, editor: dojox.grid.editors.Input, styles: 'text-align: right;'  },
			rows: [[
				{ name: "Patient Id"}, 
				{ name: "Last Name", width: 10},
				{ name: "First Name", width: 10}
			]]
		};
		return layout;
	},
	
	/**
	* Submit request to get json data.
	*/
	getJsonData: function(url) 
	{
		//specify paramaters for xhrGet request of data
		var params = {
				sync: true,
				url: url,
				headers:{Accept:"application/json"}, //ask for JSON data to be returned
				handleAs: "json"
		}
		//return json response
		if(url)
			return dojo.xhrGet(params);
		else
			console.log("Data URL Required for DeviceDataWidget");
	},
	
	onClear: function(){
		this.grid.selection.unselectAll();
	},
	
	addPatientDialog: function()
	{
		patientDialog = new stepstone.AddPatientDialog();
		dojo.connect(patientDialog, "execute", this, "update");
		patientDialog.show();
	},
	
	update: function()
	{
		var store;
		var readingList;
		if (this.inputType == "json"){
			//get JSON data
			var jsonData = this.getJsonData(this.url);
			readingList = jsonData.results[0].data.readings;
		
			//pass reading data to store
			store = new dojox.data.jsonPathStore({data: readingList});
			//var store = new dojox.data.jsonPathStore({url: dataFeedUrl});
		}else{
			alert("content type " + this.inputType + " not supported");
		} 

		//pass store to dojo data to allow dojo data to be used with Grid
		var model = new dojox.grid.data.DojoData(null, store, {clientSort: true, query: {}});
		this.grid.setModel(model);
	}
});
