/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
dojo.provide("stepstone.deviceData");
dojo.require("stepstone.DeviceDataWidget");
dojo.require("stepstone.messageData");

/** 
* The functions in this file are used to retrieve the available devices.
*/

/**
* Do not add additional information to URI
*/   
stepstone.deviceData.updateAllDeviceData = function() {
	stepstone.deviceData.updateData("");
}

/**
* Concatenate patient information to URI (eg /devices/weight becomes /devices/weight?patientId=<patientURL>)
*/
stepstone.deviceData.updatePatientDeviceData = function(patientURL) {
	stepstone.deviceData.updateData(patientURL);
}

/**
* Used to update all grids at once, updates depending on what URL was passed in.
*/
stepstone.deviceData.updateData = function(addtlInfo) {
	var data = stepstone.deviceData.getInitialDevices();
	var response = data.results[0].devices;
       
	//loop through device list
	for (i in response) {
	    var deviceURL = response[i].url;   
    	var deviceName = response[i].deviceName;   
		var completeURL = "devices/" + deviceURL + addtlInfo;
		stepstone.deviceData.initializeGridData(deviceURL, deviceName, completeURL);
    };
}

stepstone.deviceData.getInitialDevices = function() {
	params = {
		sync: true,
		url: "devices", //URI includes list of all devices available
		handleAs: "json"
	};
	//return json response
	return dojo.xhrGet(params);
}

/**
* Takes in the name of the device to dynamically update the device container
* and the completeURL to set the grid.
* @parameter url the url of the specific device (ex. "weight")
* @parameter deviceName the name of the device
* @parameter completeURL the complete URL to retreive data from (ex. "devices/weight" or "devices/temperature?patientId=12345")
*/
stepstone.deviceData.initializeGridData = function(url, deviceName, completeUrl) 
{
   	var container = url + "Container";
   	//check to see if specific device container already exists.  No? Create it.  Yes? update grid.
   	if(!dijit.byId(container)) {
   		//create div tag for each device to go in title pane
   		//hack: message handled different than other devices
   		if(url == "message") {
			//create container for each title pane
	   		var messageDiv = document.createElement("div");
	   		messageDiv.setAttribute("id", "messageContainer");
	   		dojo.byId("deviceContainer").appendChild(messageDiv);
	   		
	   		//create specific device title pane
	   		var title = deviceName + " Data";
	   		var floatPane = new dijit.TitlePane({
	   			title: title
	   		}, messageDiv);

    		stepstone.messageData.handleMessage();
    		floatPane.startup();
    	} else{
    		var widgetDiv = document.createElement("div");
    		widgetDiv.setAttribute("id", container);
	   		dojo.byId("deviceContainer").appendChild(widgetDiv);
	
    		var deviceWidget = new stepstone.DeviceDataWidget({dataFeedUrl:completeUrl, title:deviceName}, widgetDiv);
    		var patientGrid = dijit.byId('patientListContainer').grid;
    		//connect patient selection events to device data grid widgets to display data for selected patient
			dojo.connect(patientGrid, "onSelected", deviceWidget, function(event){
				var selectedPatient = patientGrid.model.getDatum(event,0);
				this.filter("$[?(@.PatientId=='" + selectedPatient + "')]");
			});
			dojo.connect(patientGrid, "onDeselected", deviceWidget, function(event){
				this.filter({});
			});    		
    	}
    }
}