/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
dojo.provide("stepstone.messageData");

/**
* The functions in this file are primarily responsible for displaying the markup data for user to submit a message.  It is also
* responsible for sending the priority and message data.
*/

/**
* If user leaves a message blank, a confirmation box questions if they would still like to submit.
*/
stepstone.messageData.checkInput = function(){
	if(document.getElementById("messageData").value.length == 0){
		var conf = confirm("Submit reading with a blank message?")
		if(conf) {
			stepstone.messageData.sendMessage();
		}
	} else {
		stepstone.messageData.sendMessage();
	}
}

/**
* Submit message and priority via POST.  Use rawXhrPost so that page does not completely refresh once submitted.
*/
stepstone.messageData.sendMessage = function(){
 	//specify paramaters for xhr request of data
	var params = {
			sync: true,
			url: "devices/message",
			headers: {"Priority": dijit.byId("priority").value},
			method: "post",
			contentType: "text/plain",
			postData: dijit.byId("messageData").getValue()
	}
	dojo.rawXhrPost(params);
	dijit.byId("messageData").reset(); //reset value
	dijit.byId("priority").reset(); //reset value
}

/**
* Responsible for correctly displaying message markup.
*/
stepstone.messageData.handleMessage = function(){
	var floatPane = dijit.byId("messageContainer");
	floatPane.setHref("devices/message"); //set html markup on content pane
}
