/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.core;

import java.util.Hashtable;
import org.eclipse.soda.sat.core.util.LogUtility;

public class PropertyManager {
    private static final PropertyManager INSTANCE = new PropertyManager();
    private Hashtable cache = new Hashtable();

    public static String getProperty(String property, String defaultValue) {
        return INSTANCE.instanceGetProperty(property, defaultValue);
    }

    public static String getProperty(String property) {
        return INSTANCE.instanceGetProperty(property);
    }

    private PropertyManager() {
    }

    private String instanceGetProperty(String property, String defaultValue) {
        if (this.cache.containsKey(property)) {
            return (String)this.cache.get(property);
        }
        String value = System.getProperty(property, defaultValue);
        LogUtility.logDebug((String)("Property: -D" + property + "=" + value));
        this.cache.put(property, value);
        return value;
    }

    private String instanceGetProperty(String property) {
        if (this.cache.containsKey(property)) {
            return (String)this.cache.get(property);
        }
        String value = System.getProperty(property);
        LogUtility.logDebug((String)("Property: -D" + property + "=" + value));
        if (value != null) {
            this.cache.put(property, value);
        }
        return value;
    }
}

