/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.core;

import org.eclipse.soda.stepstone.core.IWork;

public class Worker {
    private String name;
    private boolean running;
    private Thread thread;
    private IWork work;
    private final Object lock = new Object();

    public Worker(String name, IWork work) {
        this.setRunning(false);
        this.setName(name);
        this.setWork(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                return;
            }
            this.setRunning(true);
            Runnable runnable = this.createRunnable();
            String name = this.getName();
            Thread thread = new Thread(runnable, "Worker-" + name);
            this.setThread(thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning()) {
                return;
            }
            this.setRunning(false);
            Thread thread = this.getThread();
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Worker worker = this;
        synchronized (worker) {
            return this.running;
        }
    }

    private String getName() {
        return this.name;
    }

    private Thread getThread() {
        return this.thread;
    }

    private IWork getWork() {
        return this.work;
    }

    private void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean running) {
        Worker worker = this;
        synchronized (worker) {
            this.running = running;
        }
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    private void setWork(IWork work) {
        this.work = work;
    }

    private Runnable createRunnable() {
        Runnable runnable = new Runnable(){

            public void run() {
                Worker.this.process();
            }
        };
        return runnable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process() {
        IWork work = this.getWork();
        boolean keepRunning = true;
        try {
            try {
                while (keepRunning && this.isRunning()) {
                    keepRunning = work.doWork();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setRunning(false);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setRunning(false);
            return;
        }
    }
}

