/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.sim.swt.shell;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.stepstone.dev.sim.framework.DeviceGroup;
import org.eclipse.soda.stepstone.dev.sim.service.IDeviceSimulatorListener;
import org.eclipse.soda.stepstone.dev.sim.service.IDeviceSimulatorService;
import org.eclipse.soda.stepstone.dev.sim.swt.shell.service.IDeviceSimulatorSwtShellService;
import org.eclipse.soda.stepstone.dev.sim.swt.shell.service.ISimulatorPanel;
import org.eclipse.soda.stepstone.swt.display.service.ISwtDisplayService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeviceSimulatorSwtShell
implements IDeviceSimulatorSwtShellService,
IDeviceSimulatorListener {
    private Combo panelCombo;
    private Combo idCombo;
    private ISimulatorPanel displayedPanel;
    private Composite panelComposite;
    private Map panels = new Hashtable(5);
    private Shell shell;
    private ISwtDisplayService swtDisplay;
    private IDeviceSimulatorService deviceSimulator;
    private Runnable unloadCompositeRunnable = this.createUnloadCompositeRunnable();
    private DeviceGroup currentDeviceGroup = null;

    public void bind(ISwtDisplayService swtDisplay, IDeviceSimulatorService deviceSimulator) {
        this.swtDisplay = swtDisplay;
        this.deviceSimulator = deviceSimulator;
        this.open();
        deviceSimulator.addListener("SHELL", (IDeviceSimulatorListener)this);
    }

    public void unbind() {
        this.close();
        this.deviceSimulator.removeListener("SHELL");
        this.deviceSimulator = null;
        this.swtDisplay = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPanel(ISimulatorPanel panel) {
        DeviceSimulatorSwtShell deviceSimulatorSwtShell = this;
        synchronized (deviceSimulatorSwtShell) {
            boolean exists = this.panels.containsValue(panel);
            if (exists) {
                return;
            }
            String key = panel.getLabel();
            this.panels.put(key, panel);
        }
        this.addPanelToCombo(panel);
    }

    public void uninstallPanel(ISimulatorPanel panel) {
        this.panels.remove(panel.getLabel());
        this.removePanelFromCombo(panel);
        if (panel == this.displayedPanel) {
            this.unloadComposite();
        }
    }

    public Display getDisplay() {
        return this.swtDisplay.getDisplay();
    }

    public DeviceGroup getSelectedDeviceGroup() {
        return this.currentDeviceGroup;
    }

    public void deviceGroupListChanged() {
        final DeviceGroup[] deviceGroups = this.deviceSimulator.getDeviceGroups();
        this.syncExec(new Runnable(){

            public void run() {
                DeviceSimulatorSwtShell.this.idCombo.removeAll();
                if (deviceGroups.length > 0) {
                    int selected = 0;
                    int i = 0;
                    while (i < deviceGroups.length) {
                        DeviceSimulatorSwtShell.this.idCombo.add(deviceGroups[i].getId());
                        if (deviceGroups[i] == DeviceSimulatorSwtShell.this.currentDeviceGroup) {
                            selected = i;
                            break;
                        }
                        ++i;
                    }
                    DeviceSimulatorSwtShell.this.idCombo.select(selected);
                    DeviceSimulatorSwtShell.this.currentDeviceGroup = deviceGroups[selected];
                } else {
                    DeviceSimulatorSwtShell.this.currentDeviceGroup = null;
                }
                Iterator iter = DeviceSimulatorSwtShell.this.panels.values().iterator();
                while (iter.hasNext()) {
                    ISimulatorPanel panel = (ISimulatorPanel)iter.next();
                    panel.selectedDeviceGroupChanged(DeviceSimulatorSwtShell.this.currentDeviceGroup);
                }
            }
        });
    }

    public void receivedMessage(String prefix, String message, DeviceGroup deviceGroup) {
    }

    private void addPanelToCombo(ISimulatorPanel panel) {
        final String label = panel.getLabel();
        this.syncExec(new Runnable(){

            public void run() {
                DeviceSimulatorSwtShell.this.panelCombo.add(label);
            }
        });
    }

    private void buildComposites(Composite parent) {
        this.buildPanelCombo(parent);
        this.buildIdCombo(parent);
        this.buildPanelComposite(parent);
    }

    private void buildPanelCombo(Composite parent) {
        this.panelCombo = new Combo(parent, 8);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(60, 0);
        this.panelCombo.setLayoutData((Object)data);
        this.panelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = DeviceSimulatorSwtShell.this.panelCombo.getSelectionIndex();
                String item = DeviceSimulatorSwtShell.this.panelCombo.getItem(index);
                ISimulatorPanel panel = (ISimulatorPanel)DeviceSimulatorSwtShell.this.panels.get(item);
                DeviceSimulatorSwtShell.this.displayPanel(panel);
            }
        });
    }

    private void buildIdCombo(Composite parent) {
        this.idCombo = new Combo(parent, 8);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(61, 0);
        data.right = new FormAttachment(100, 0);
        this.idCombo.setLayoutData((Object)data);
        this.idCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = DeviceSimulatorSwtShell.this.panelCombo.getSelectionIndex();
                if (index >= 0) {
                    String id = DeviceSimulatorSwtShell.this.panelCombo.getItem(index);
                    DeviceSimulatorSwtShell.this.currentDeviceGroup = DeviceSimulatorSwtShell.this.deviceSimulator.getDeviceGroup(id);
                    Iterator iter = DeviceSimulatorSwtShell.this.panels.values().iterator();
                    while (iter.hasNext()) {
                        ISimulatorPanel panel = (ISimulatorPanel)iter.next();
                        panel.selectedDeviceGroupChanged(DeviceSimulatorSwtShell.this.currentDeviceGroup);
                    }
                }
            }
        });
    }

    private void buildPanelComposite(Composite parent) {
        this.panelComposite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        this.panelComposite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.panelCombo, 3);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.panelComposite.setLayoutData((Object)data);
    }

    private void open() {
        this.syncExec(new Runnable(){

            public void run() {
                Display display = DeviceSimulatorSwtShell.this.getDisplay();
                DeviceSimulatorSwtShell.this.shell = new Shell(display, 160);
                FormLayout layout = new FormLayout();
                DeviceSimulatorSwtShell.this.shell.setLayout((Layout)layout);
                DeviceSimulatorSwtShell.this.shell.setSize(200, 290);
                DeviceSimulatorSwtShell.this.shell.setText("Device Simulator");
                DeviceSimulatorSwtShell.this.buildComposites((Composite)DeviceSimulatorSwtShell.this.shell);
                DeviceSimulatorSwtShell.this.shell.layout();
                DeviceSimulatorSwtShell.this.shell.open();
            }
        });
        this.deviceGroupListChanged();
    }

    private void close() {
        this.syncExec(new Runnable(){

            public void run() {
                DeviceSimulatorSwtShell.this.shell.dispose();
                DeviceSimulatorSwtShell.this.shell = null;
            }
        });
    }

    private Runnable createUnloadCompositeRunnable() {
        return new Runnable(){

            public void run() {
                DeviceSimulatorSwtShell.this.processUnloadComposite();
            }
        };
    }

    private void displayPanel(ISimulatorPanel panel) {
        this.unloadComposite();
        panel.loadComposite(this.panelComposite);
        this.displayedPanel = panel;
        this.panelComposite.layout();
    }

    private void disposeControls(Control[] controls) {
        int count = controls.length;
        int i = 0;
        while (i < count) {
            Control control = controls[i];
            control.dispose();
            ++i;
        }
    }

    private void processUnloadComposite() {
        Control[] children = this.panelComposite.getChildren();
        this.disposeControls(children);
    }

    private void removePanelFromCombo(ISimulatorPanel panel) {
        final String label = panel.getLabel();
        this.syncExec(new Runnable(){

            public void run() {
                if (!DeviceSimulatorSwtShell.this.panelCombo.isDisposed()) {
                    DeviceSimulatorSwtShell.this.panelCombo.remove(label);
                }
            }
        });
    }

    private void syncExec(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null");
        }
        Display display = this.getDisplay();
        display.syncExec(runnable);
    }

    private void unloadComposite() {
        this.syncExec(this.unloadCompositeRunnable);
    }
}

