/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.sim;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.dev.sim.DeviceSimulatorServlet;
import org.eclipse.soda.stepstone.dev.sim.framework.DeviceGroup;
import org.eclipse.soda.stepstone.dev.sim.service.IDeviceSimulatorListener;
import org.eclipse.soda.stepstone.dev.sim.service.IDeviceSimulatorService;
import org.osgi.service.http.HttpService;

public class DeviceSimulator
implements IDeviceSimulatorService {
    private Map listeners = new Hashtable(47);
    private DeviceSimulatorServlet servlet;
    private Map deviceGroups = new Hashtable(5);

    public void bind(HttpService httpService) {
        this.servlet = new DeviceSimulatorServlet();
        this.servlet.startUp(httpService, this);
    }

    public void unbind() {
        this.servlet.shutDown();
        this.servlet = null;
    }

    public void messageReceived(String prefix, String message, String senderIpAddress, String id) {
        if ("connect".equals(prefix)) {
            this.handleConnection(senderIpAddress, message, id);
        } else {
            DeviceGroup deviceGroup = (DeviceGroup)this.deviceGroups.get(id);
            if (deviceGroup == null) {
                LogUtility.logWarning((Object)this, (String)("Message recieved from unknown id (" + id + ")"));
                return;
            }
            IDeviceSimulatorListener listener = (IDeviceSimulatorListener)this.listeners.get(prefix);
            if (listener == null) {
                return;
            }
            listener.receivedMessage(prefix, message, deviceGroup);
        }
    }

    public void addListener(String prefix, IDeviceSimulatorListener listener) {
        this.listeners.put(prefix, listener);
    }

    public void removeListener(String prefix) {
        this.listeners.remove(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceGroup[] getDeviceGroups() {
        Map map = this.deviceGroups;
        synchronized (map) {
            DeviceGroup[] deviceGroupArray = new DeviceGroup[this.deviceGroups.size()];
            int i = 0;
            Iterator iter = this.deviceGroups.values().iterator();
            while (iter.hasNext()) {
                deviceGroupArray[i] = (DeviceGroup)iter.next();
                ++i;
            }
            return deviceGroupArray;
        }
    }

    public DeviceGroup getDeviceGroup(String id) {
        return (DeviceGroup)this.deviceGroups.get(id);
    }

    public String toString() {
        return "DeviceSimulator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleConnection(String senderIpAddress, String portMessage, String id) {
        Map map = this.deviceGroups;
        synchronized (map) {
            this.deviceGroups.put(id, new DeviceGroup(id, String.valueOf(senderIpAddress) + ":" + portMessage));
            Iterator iter = this.listeners.values().iterator();
            while (iter.hasNext()) {
                IDeviceSimulatorListener listener = (IDeviceSimulatorListener)iter.next();
                listener.deviceGroupListChanged();
            }
        }
        LogUtility.logWarning((Object)this, (String)("Device simulator (id " + id + ") connected from " + senderIpAddress + ":" + portMessage));
    }
}

