/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.sim;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.dev.sim.DeviceSimulator;
import org.eclipse.soda.stepstone.dev.sim.DeviceSimulatorHttpProcessor;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class DeviceSimulatorServlet
extends HttpServlet {
    private HttpService httpService;
    private DeviceSimulatorHttpProcessor processor;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processor.process(request, response);
    }

    private String getAlias() {
        return "/devsim";
    }

    public void shutDown() {
        String alias = this.getAlias();
        this.httpService.unregister(alias);
        this.httpService = null;
        this.processor = null;
    }

    public void startUp(HttpService httpService, DeviceSimulator deviceSimulator) {
        this.processor = new DeviceSimulatorHttpProcessor(deviceSimulator);
        this.httpService = httpService;
        try {
            String alias = this.getAlias();
            httpService.registerServlet(alias, (Servlet)this, null, null);
            LogUtility.logInfo((Object)"DeviceSimulatorServlet", (String)"Servlet successfully registered");
        }
        catch (ServletException exception) {
            LogUtility.logError((Object)"DeviceSimulatorServlet", (String)"Unable to register servlet", (Throwable)exception);
        }
        catch (NamespaceException exception) {
            LogUtility.logError((Object)"DeviceSimulatorServlet", (String)"Unable to register servlet", (Throwable)exception);
        }
    }
}

