/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.sim.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.sat.core.util.LogUtility;

public class DeviceGroup {
    private String id;
    private String host;
    private Map properties;

    public DeviceGroup(String id, String host) {
        this.id = id;
        this.host = host;
        this.properties = new Hashtable(23);
    }

    public String getHost() {
        return this.host;
    }

    public String getId() {
        return this.id;
    }

    public boolean sendMessage(String prefix, String message) {
        URL url = this.createUrl(prefix, message, this.host);
        boolean success = this.sendMessage(url);
        if (!success) {
            LogUtility.logError((Object)this, (String)("Unable to send to simulated device at " + this.host));
        }
        return success;
    }

    private boolean sendMessage(URL url) {
        String reply = null;
        boolean success = false;
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            reply = bufferedReader.readLine();
            inputStream.close();
            success = "simdev/ack".equals(reply);
        }
        catch (IOException e) {
            LogUtility.logError((Object)this, (String)("Failed to send message " + url), (Throwable)e);
        }
        return success;
    }

    private URL createUrl(String action, String message, String host) {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("http://");
        buffer.append(host);
        buffer.append('/');
        buffer.append("simdev");
        buffer.append('?');
        buffer.append("action");
        buffer.append('=');
        buffer.append(action);
        buffer.append('&');
        buffer.append("message");
        buffer.append('=');
        buffer.append(message);
        String spec = buffer.toString();
        URL url = null;
        try {
            url = new URL(spec);
        }
        catch (MalformedURLException exception) {
            LogUtility.logDebug((Object)this, (String)("Failed to create URL: " + spec), (Throwable)exception);
        }
        return url;
    }

    public Object getProperty(String prefix, String key) {
        return this.properties.get(String.valueOf(prefix) + "::" + key);
    }

    public void setProperty(String prefix, String key, Object value) {
        this.properties.put(String.valueOf(prefix) + "::" + key, value);
    }
}

