/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.simd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.core.IWork;
import org.eclipse.soda.stepstone.core.PropertyManager;
import org.eclipse.soda.stepstone.core.Worker;
import org.eclipse.soda.stepstone.dev.simd.ISimulatedDeviceServletListener;
import org.eclipse.soda.stepstone.dev.simd.SimulatedDeviceServlet;
import org.eclipse.soda.stepstone.dev.simd.service.ISimulatedDeviceListener;
import org.eclipse.soda.stepstone.dev.simd.service.ISimulatedDeviceService;
import org.osgi.service.http.HttpService;

public class SimulatedDevice
implements ISimulatedDeviceService,
ISimulatedDeviceServletListener {
    private static final String HOST = PropertyManager.getProperty((String)"stepstone.dev.sim.host", (String)"localhost");
    private boolean isConnected;
    private boolean alreadyLogged;
    private Worker worker;
    private Map listeners;
    private SimulatedDeviceServlet servlet;

    public void bind(HttpService httpService) {
        this.listeners = new Hashtable(2);
        this.servlet = new SimulatedDeviceServlet();
        this.servlet.startUp(httpService, this);
        this.alreadyLogged = false;
        this.launchConnectThread();
    }

    public void unbind() {
        if (this.worker != null) {
            this.worker.stop();
        }
        this.servlet.shutDown();
    }

    public void addListener(String prefix, ISimulatedDeviceListener listener) {
        this.listeners.put(prefix, listener);
    }

    public void removeListener(String prefix) {
        this.listeners.remove(prefix);
    }

    public boolean send(String prefix, String message) {
        if (this.isConnected) {
            return this.sendMessage(prefix, message, this.getPort());
        }
        return false;
    }

    public void messageReceived(String prefix, String message) {
        ISimulatedDeviceListener listener = (ISimulatedDeviceListener)this.listeners.get(prefix);
        if (listener == null) {
            return;
        }
        listener.receivedMessage(prefix, message);
    }

    private void launchConnectThread() {
        this.isConnected = false;
        this.worker = new Worker("SimulatedDeviceLaunch", new IWork(){

            public boolean doWork() throws InterruptedException {
                return SimulatedDevice.this.runProcess();
            }
        });
        this.worker.start();
    }

    protected boolean runProcess() throws InterruptedException {
        this.isConnected = this.connect(HOST, false);
        if (!this.isConnected) {
            Thread.sleep(1000L);
            this.isConnected = this.connect(HOST, true);
        }
        if (this.isConnected) {
            LogUtility.logWarning((Object)this.getId(), (String)("Connected to device simulator at " + HOST));
        }
        return !this.isConnected;
    }

    private boolean connect(String host, boolean issueWarning) {
        String targetPort = this.getPort();
        boolean success = this.sendMessage("connect", targetPort, targetPort);
        if (issueWarning && !success && !this.alreadyLogged) {
            LogUtility.logWarning((Object)this.getId(), (String)("Unable to connect to device simulator at " + HOST + ":" + targetPort + ". Retrying..."));
            this.alreadyLogged = true;
        }
        return success;
    }

    private String getId() {
        return "SimulatedDevice";
    }

    private boolean sendMessage(String action, String message, String port) {
        URL url;
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("http://");
        buffer.append(HOST);
        if (!port.equals("80")) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append('/');
        buffer.append("devsim");
        buffer.append('?');
        buffer.append("id");
        buffer.append('=');
        buffer.append(this.getVin());
        buffer.append('&');
        buffer.append("action");
        buffer.append('=');
        buffer.append(action);
        buffer.append('&');
        buffer.append("message");
        buffer.append('=');
        buffer.append(message);
        try {
            url = new URL(buffer.toString());
        }
        catch (MalformedURLException e) {
            LogUtility.logError((Object)this.getId(), (String)"Unable to send message to device simulator", (Throwable)e);
            return false;
        }
        String result = null;
        try {
            InputStream reply = url.openStream();
            InputStreamReader reader = new InputStreamReader(reply);
            BufferedReader bufferedReader = new BufferedReader(reader);
            result = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return false;
        }
        return "devsim/ack".equals(result);
    }

    private String getVin() {
        return PropertyManager.getProperty((String)"stepstone.id", (String)"12AB78");
    }

    private String getPort() {
        return PropertyManager.getProperty((String)"stepstone.dev.simd.port", (String)"8081");
    }
}

