/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dev.simd;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.stepstone.dev.simd.ISimulatedDeviceServletListener;

public class SimulatedDeviceHttpProcessor {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ISimulatedDeviceServletListener listener;

    public SimulatedDeviceHttpProcessor(ISimulatedDeviceServletListener listener) {
        this.listener = listener;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        String action = request.getParameter("action");
        if (action == null || action.length() == 0) {
            response.sendError(406, "Missing from");
        } else {
            response.setContentType("text/plain");
            this.handleActionRequest(action);
        }
    }

    private void handleActionRequest(String action) throws IOException {
        String message = this.request.getParameter("message");
        PrintWriter writer = this.response.getWriter();
        writer.println("simdev/ack");
        this.listener.messageReceived(action, message);
    }
}

