/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dk.bluetooth.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.microedition.io.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.stepstone.dk.bluetooth.connection.service.BluetoothConnectionService;

public abstract class BluetoothConnection
extends org.eclipse.soda.dk.connection.StreamConnection
implements BluetoothConnectionService,
ConnectionService {
    private List byteBuffer = Collections.synchronizedList(new LinkedList());
    protected boolean connected = false;
    protected static final char[] TOSTRING_NAME = "BluetoothConnection[".toCharArray();
    protected long receivedTotalTimeout = 1000L;

    protected abstract Thread getConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() throws IOException {
        this.setOpen(true);
        Thread thread = this.getConnectionManager();
        synchronized (thread) {
            this.getConnectionManager().notify();
        }
    }

    public synchronized void close() throws IOException {
        this.connected = false;
        super.close();
        this.getConnectionManager().interrupt();
        this.handleError(null, 1002, this.toString());
    }

    public long getReceivedTotalTimeout() {
        return this.receivedTotalTimeout;
    }

    public void setReceivedTotalTimeout(long timeout) {
        this.receivedTotalTimeout = timeout;
    }

    public String getType() {
        return "bluetooth";
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int readyBytes = this.byteBuffer.size();
        if (readyBytes == 0) {
            List list = this.byteBuffer;
            synchronized (list) {
                try {
                    this.byteBuffer.wait(this.getReceivedTotalTimeout());
                }
                catch (Exception exception) {}
            }
            readyBytes = this.byteBuffer.size();
        }
        int bytesToRead = Math.min(length, readyBytes);
        int i = offset;
        while (i < offset + bytesToRead) {
            bytes[i] = ((Integer)this.byteBuffer.remove(0)).byteValue();
            ++i;
        }
        return bytesToRead;
    }

    protected synchronized void handleConnection(StreamConnection conn) throws IOException {
        this.setInputStream(conn.openInputStream());
        this.setOutputStream(conn.openOutputStream());
        this.connected = true;
        new ReaderThread("BluecoveBluetoothConnectionReaderThread").start();
    }

    static /* synthetic */ InputStream access$0(BluetoothConnection bluetoothConnection) {
        return bluetoothConnection.getInputStream();
    }

    static /* synthetic */ List access$1(BluetoothConnection bluetoothConnection) {
        return bluetoothConnection.byteBuffer;
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            this.setDaemon(true);
        }

        public ReaderThread(String threadName) {
            super(threadName);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            in = BluetoothConnection.access$0(BluetoothConnection.this);
            try {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        block12: {
                            block11: {
                                if (!BluetoothConnection.this.connected) break block11;
                                if (in != null) break block12;
                            }
                            var4_4 = null;
                            BluetoothConnection.this.connected = false;
                            return;
                        }
                        newByte = new Integer(in.read());
                        if (newByte == -1) ** GOTO lbl-1000
                        var3_3 = BluetoothConnection.access$1(BluetoothConnection.this);
                        synchronized (var3_3) {
                            BluetoothConnection.access$1(BluetoothConnection.this).add(newByte);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException v1) {}
                {
                    ** while (true)
                }
            }
            catch (Throwable var5_7) {
                var4_5 = null;
                BluetoothConnection.this.connected = false;
                throw var5_7;
            }
lbl-1000:
            // 2 sources

            {
                var4_6 = null;
                BluetoothConnection.this.connected = false;
                return;
            }
        }
    }
}

