/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dk.bluetooth.connection;

import java.io.IOException;
import javax.microedition.io.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.stepstone.dk.bluetooth.connection.service.BluetoothConnectionService;

public abstract class BluetoothConnection
extends org.eclipse.soda.dk.connection.StreamConnection
implements BluetoothConnectionService,
ConnectionService {
    protected boolean connected = false;
    protected static final char[] TOSTRING_NAME = "BluetoothConnection[".toCharArray();
    protected long receivedTotalTimeout = 1000L;

    protected abstract Thread getConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        this.setOpen(true);
        Thread thread = this.getConnectionManager();
        synchronized (thread) {
            this.getConnectionManager().notify();
        }
    }

    public synchronized void close() throws IOException {
        this.connected = false;
        super.close();
        this.handleError(null, 1002, this.toString());
    }

    public long getReceivedTotalTimeout() {
        return this.receivedTotalTimeout;
    }

    public void setReceivedTotalTimeout(long timeout) {
        this.receivedTotalTimeout = timeout;
    }

    public String getType() {
        return "bluetooth";
    }

    public int read(byte[] bytes) throws IOException {
        if (!this.connected) {
            return 0;
        }
        return super.read(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        while (this.getInputStream() == null) {
            Thread thread = this.getConnectionManager();
            synchronized (thread) {
                try {
                    this.getConnectionManager().wait(this.getReceivedTotalTimeout());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return super.read(bytes, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnection(StreamConnection conn) throws IOException {
        this.setInputStream(conn.openInputStream());
        this.setOutputStream(conn.openOutputStream());
        Thread thread = this.getConnectionManager();
        synchronized (thread) {
            this.connected = true;
            this.getConnectionManager().notify();
        }
    }
}

