/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dk.bluetooth.sdp.connection;

import java.io.IOException;
import java.util.Dictionary;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnectionNotifier;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.stepstone.dk.bluetooth.connection.BluetoothConnection;

public class BluetoothServer
extends BluetoothConnection {
    protected final String CONNECTION_MANAGER_THREAD_NAME = "BluetoothServerConnectionManager";
    private final String SPP_UUID = new UUID("1101", true).toString();
    protected Thread connectionManager;
    protected DiscoveryAgent discoveryAgent;

    public BluetoothServer(String serviceName) throws IllegalArgumentException, IOException {
        LocalDevice device = LocalDevice.getLocalDevice();
        device.setDiscoverable(10390323);
        String url = "btspp://localhost:" + this.SPP_UUID + ";name=" + serviceName;
        ConnectionManager manager = new ConnectionManager(url);
        this.setConnectionManager(manager);
        manager.start();
    }

    public BluetoothServer(Dictionary properties) throws IOException {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public BluetoothServer(ConfigurationService configuration) throws IOException {
        this.setConfigurationService(configuration);
        String url = "btspp://localhost:" + this.SPP_UUID + ";name=" + this.getString("serviceName", "org.eclipse.soda.dk.bluetooth.connection.service.BluetoothConnectionService");
        ConnectionManager manager = new ConnectionManager(url);
        this.setConnectionManager(manager);
        manager.start();
    }

    protected Thread getConnectionManager() {
        return this.connectionManager;
    }

    private void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    private class ConnectionManager
    extends Thread {
        private StreamConnectionNotifier notifier;
        private final int WAIT_VALUE;

        public ConnectionManager(String url) throws IOException {
            super(url);
            this.WAIT_VALUE = BluetoothServer.this.getInt("readtotaltimeout", 1000);
            this.setDaemon(true);
            this.notifier = (StreamConnectionNotifier)Connector.open((String)url);
        }

        public ConnectionManager(String url, String threadName) throws IOException {
            super(threadName);
            this.WAIT_VALUE = BluetoothServer.this.getInt("readtotaltimeout", 1000);
            this.setDaemon(true);
            this.notifier = (StreamConnectionNotifier)Connector.open((String)url);
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (BluetoothServer.this.isOpen() && !BluetoothServer.this.connected) {
                            try {
                                BluetoothServer.this.handleConnection(this.notifier.acceptAndOpen());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        this.wait(this.WAIT_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (BluetoothServer.this.isOpen()) continue;
                    return;
                }
                break;
            }
        }
    }
}

