/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.dk.bluetooth.sdp.connection;

import java.io.IOException;
import java.util.Dictionary;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.dk.bluetooth.connection.BluetoothConnection;

public class BluetoothClient
extends BluetoothConnection {
    protected final UUID uuid = new UUID(4353L);
    protected final String CONNECTION_MANAGER_THREAD_NAME = "BluetoothClientConnectionManager";
    protected final String deviceName;
    protected final String deviceService;
    protected Thread connectionManager;

    public BluetoothClient(String deviceName, String serviceName) throws IllegalArgumentException {
        this.deviceName = deviceName;
        this.deviceService = serviceName;
        this.startManager();
    }

    public BluetoothClient(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public BluetoothClient(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
        this.deviceName = this.getString("remoteDeviceName", "");
        this.deviceService = this.getString("remoteDeviceService", "");
    }

    private void startManager() {
        try {
            ConnectionManager manager = new ConnectionManager("BluetoothClientConnectionManager");
            this.setConnectionManager(manager);
            manager.start();
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    protected Thread getConnectionManager() {
        return this.connectionManager;
    }

    private void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    private String getRemoteDeviceName(RemoteDevice device) {
        try {
            return device.getFriendlyName(false);
        }
        catch (IOException iOException) {
            return device.getBluetoothAddress();
        }
    }

    private class ConnectionManager
    extends Thread
    implements DiscoveryListener {
        private final int WAIT_VALUE;
        private final DiscoveryAgent discoveryAgent;

        public ConnectionManager() throws BluetoothStateException {
            this(null);
        }

        public ConnectionManager(String threadName) throws BluetoothStateException {
            super(threadName);
            this.WAIT_VALUE = BluetoothClient.this.getInt("connectioninterval", 30000);
            this.setDaemon(true);
            this.discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if (BluetoothClient.this.isOpen() && !BluetoothClient.this.connected) {
                            try {
                                this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                            }
                            catch (IOException e) {
                                LogUtility.logDebug((String)"BluetoothClient - error occured during search for devices", (Throwable)e);
                            }
                        }
                        this.wait(this.WAIT_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (BluetoothClient.this.isOpen()) continue;
                    return;
                }
                break;
            }
        }

        public void deviceDiscovered(RemoteDevice device, DeviceClass deviceClass) {
            UUID[] uuids = new UUID[]{BluetoothClient.this.uuid};
            try {
                if (BluetoothClient.this.getRemoteDeviceName(device).equals(BluetoothClient.this.deviceName)) {
                    this.discoveryAgent.searchServices(null, uuids, device, (DiscoveryListener)this);
                }
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
            }
        }

        public void servicesDiscovered(int transId, ServiceRecord[] serviceRecords) {
            int i = 0;
            while (i < serviceRecords.length) {
                ServiceRecord serviceRecord = serviceRecords[i];
                String url = serviceRecord.getConnectionURL(0, false);
                try {
                    LogUtility.logInfo((String)("Connecting to " + url));
                    BluetoothClient.this.handleConnection((StreamConnection)Connector.open((String)url));
                    this.discoveryAgent.cancelServiceSearch(transId);
                    this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        public void inquiryCompleted(int arg0) {
        }

        public void serviceSearchCompleted(int transId, int responseCode) {
        }
    }
}

