/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.soa.muse.webservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.soa.api.ISoaListener;
import org.eclipse.soda.stepstone.soa.api.ISoaService;
import org.eclipse.soda.stepstone.soa.muse.webservices.RemoteSoaWebService;

public class SoaWebServicesAgent
implements ISoaService {
    private List listeners = new ArrayList();
    private List topics = new ArrayList();

    public SoaWebServicesAgent() {
        LogUtility.logDebug((String)"SoaWebServicesAgent - Started up");
    }

    public void notifySendWithoutReply(String serverId, String sendType, String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, Date dateTime, String remoteAddress) {
        LogUtility.logDebug((Object)"SoaWebServicesAgent", (String)"received:");
        LogUtility.logDebug((String)("... serverId=" + serverId + "; sendType=" + sendType + "; edgeId=" + edgeId));
        LogUtility.logDebug((String)("... unitId=" + unitId + "; deviceType=" + deviceType + "; deviceId=" + deviceId));
        LogUtility.logDebug((String)("... parameterName=" + parameterName + "; parameterValue=" + parameterValue + "; dateTime=" + dateTime));
        List listeners = this.getListenersByTopic(sendType);
        if (listeners != null) {
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ISoaListener listener = (ISoaListener)iter.next();
                listener.messageArrived(serverId, sendType, edgeId, unitId, deviceType, deviceId, parameterName, parameterValue, remoteAddress);
            }
        }
    }

    public void sendWithoutReply(String serverId, String sendType, String edgeId, String unitId, String deviceType, String deviceId, String parameterName, String parameterValue, Date dateTime) {
        RemoteSoaWebService proxy = new RemoteSoaWebService();
        proxy.sendWithoutReply(serverId, sendType, edgeId, unitId, deviceType, deviceId, parameterName, parameterValue, dateTime);
        LogUtility.logDebug((Object)"SoaWebServicesAgent", (String)"sent:");
        LogUtility.logDebug((String)("... serverId=" + serverId + "; sendType=" + sendType + "; edgeId=" + edgeId));
        LogUtility.logDebug((String)("... unitId=" + unitId + "; deviceType=" + deviceType + "; deviceId=" + deviceId));
        LogUtility.logDebug((String)("... parameterName=" + parameterName + "; parameterValue=" + parameterValue + "; dateTime=" + dateTime));
    }

    public void addListener(ISoaListener listener, String sendType, String edgeId, String unitId, String deviceType, String deviceId) {
        LogUtility.logDebug((String)("SoaWebServicesAgent - addListener: " + sendType));
        this.addListenerByTopic(listener, sendType);
    }

    public void removeListener(ISoaListener listener, String sendType, String edgeId, String unitId, String deviceType, String deviceId) {
        LogUtility.logDebug((String)("SoaWebServicesAgent - removeListener: " + sendType));
        this.removeListenerByTopic(listener, sendType);
    }

    private void addListenerByTopic(ISoaListener listener, String topic) {
        this.listeners.add(listener);
        this.topics.add(topic);
    }

    private void removeListenerByTopic(ISoaListener listener, String topic) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (listener == this.listeners.get(i) && topic.equals(this.topics.get(i))) {
                this.listeners.remove(i);
                this.topics.remove(i);
                return;
            }
            ++i;
        }
    }

    private List getListenersByTopic(String topic) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.listeners.size()) {
            if (topic.startsWith((String)this.topics.get(i))) {
                result.add(this.listeners.get(i));
            }
            ++i;
        }
        return result;
    }
}

