/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.soap.muse.http.webservices;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.muse.ws.addressing.soap.SimpleSoapClient;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.soap.muse.SoapEnvelope;
import org.eclipse.soda.stepstone.soap.muse.SoapFaultEnvelope;

public abstract class RemoteHttpWebServiceInvocation
extends SimpleSoapClient {
    private String service_url = "";
    private QName service_qname;
    public static final int MAX_INPUT_BUFFER_SIZE = 4096;

    public RemoteHttpWebServiceInvocation(String service_url, QName service_qname) {
        this.service_url = service_url;
        this.service_qname = service_qname;
        LogUtility.logInfo((String)("Remote Web Service Created[URL=" + this.service_url + " Name=" + this.service_qname + "]"));
    }

    public String getServiceName() {
        return this.service_qname.getLocalPart();
    }

    public abstract List getSerializers();

    public SoapEnvelope invokeRemoteService(SoapEnvelope soapRequest) {
        SoapEnvelope soapResult = null;
        byte[] soapBytes = soapRequest.getBytes(true);
        if (this.isUsingTrace()) {
            this.trace(soapRequest.getEnvelopeElement(), false);
        }
        try {
            URL url = new URL(this.service_url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/soap+xml");
            connection.setRequestProperty("SOAPAction", "sendWithoutReply");
            connection.setDoOutput(true);
            connection.connect();
            OutputStream output = connection.getOutputStream();
            output.write(soapBytes);
            output.flush();
            output.close();
            int responseCode = connection.getResponseCode();
            InputStream response = null;
            response = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            soapResult = new SoapEnvelope(response);
            response.close();
            connection.disconnect();
        }
        catch (Throwable error) {
            return new SoapFaultEnvelope(error.getMessage());
        }
        if (this.isUsingTrace()) {
            this.trace(soapResult.getEnvelopeElement(), true);
        }
        return soapResult;
    }
}

