/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.soap.muse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.eclipse.soda.stepstone.soap.muse.ParameterSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SoapEnvelope {
    private static String XML_VERSION_HEADER = "<?xml version='1.0' encoding='utf-8'?>";
    protected Document doc;
    protected Element envelopeElement;

    public SoapEnvelope() {
        this.doc = XmlUtils.createDocument();
        this.envelopeElement = XmlUtils.createElement((Document)this.doc, (QName)SoapConstants.ENVELOPE_QNAME);
        this.envelopeElement.setAttributeNS("xmlns", "soap", "http://www.w3.org/2003/05/soap-envelope");
    }

    public SoapEnvelope(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            this.doc = XmlUtils.createDocument((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.envelopeElement = XmlUtils.getFirstElement((Node)this.doc);
    }

    public SoapEnvelope(InputStream inStream) {
        try {
            this.doc = XmlUtils.createDocument((InputStream)inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.envelopeElement = XmlUtils.getFirstElement((Node)this.doc);
    }

    public Element getEnvelopeElement() {
        return this.envelopeElement;
    }

    public byte[] getBytes() {
        return XmlUtils.toString((Node)this.envelopeElement).getBytes();
    }

    public byte[] getBytes(boolean includeXMLVersion) {
        if (includeXMLVersion) {
            return this.getBytes();
        }
        StringBuffer buff = new StringBuffer(2000);
        buff.append(XML_VERSION_HEADER);
        buff.append(XmlUtils.toString((Node)this.envelopeElement));
        return buff.toString().getBytes();
    }

    protected Element getHeader() {
        return XmlUtils.getElement((Node)this.envelopeElement, (QName)SoapConstants.HEADER_QNAME);
    }

    protected Element getBodyElement() {
        return XmlUtils.getElement((Node)this.envelopeElement, (QName)SoapConstants.BODY_QNAME);
    }

    public String toString() {
        return XmlUtils.toString((Node)this.envelopeElement);
    }

    public void toWriter(Writer writer) {
        try {
            writer.write(this.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isFault() {
        return false;
    }

    public QName getService() {
        Node actionElement;
        QName value = null;
        Element bodyElement = this.getBodyElement();
        if (bodyElement != null && (actionElement = bodyElement.getFirstChild()) != null) {
            value = new QName(actionElement.getNamespaceURI(), actionElement.getLocalName(), actionElement.getPrefix());
        }
        return value;
    }

    public Node getServiceElement() {
        Node actionElement = null;
        Element bodyElement = this.getBodyElement();
        if (bodyElement != null) {
            actionElement = bodyElement.getFirstChild();
        }
        return actionElement;
    }

    public void setService(QName action) {
        Element newElement = XmlUtils.createElement((Document)this.doc, (QName)action);
        Node oldElement = this.getServiceElement();
        if (oldElement == null) {
            this.getBodyElement().appendChild(newElement);
        } else {
            this.getBodyElement().replaceChild(newElement, oldElement);
        }
    }

    public String getServiceName() {
        return this.getServiceElement().getLocalName();
    }

    public int getServiceParameterCount() {
        return this.getServiceElement().getChildNodes().getLength();
    }

    public Element getServiceParameterElement(int index) {
        return (Element)this.getServiceElement().getChildNodes().item(index);
    }

    public void addServiceParameterElement(Element parameter) {
        this.getServiceElement().appendChild(parameter);
    }

    public void addServiceParameterElement(Object parameter, ParameterSerializer parmSerializer) {
        try {
            Element parmElement = XmlUtils.createElement((Document)this.doc, (QName)parmSerializer.getQname(), (Object)parameter);
            this.getServiceElement().appendChild(parmElement);
        }
        catch (DOMException exception) {
            exception.printStackTrace();
        }
    }
}

