/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.stepstone.swt.display;

import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.stepstone.swt.display.service.ISwtDisplayService;
import org.eclipse.swt.widgets.Display;

public class SwtDisplay
implements ISwtDisplayService {
    private Display display;
    private boolean running;
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUp() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            if (this.isRunning()) {
                return;
            }
            this.running = true;
        }
        this.startSwtDisplayThread();
        this.waitForDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.shutDownSwtDisplayThread();
    }

    public Display getDisplay() {
        return this.display;
    }

    private Runnable createShellRunnable() {
        Runnable runnable = new Runnable(){

            public void run() {
                SwtDisplay.this.processCreateShell();
            }
        };
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processCreateShell() {
        var1_1 = this;
        synchronized (var1_1) {
            this.display = new Display();
            this.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl14
        }
        do {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
lbl14:
            // 3 sources

        } while (this.isRunning());
        this.display.dispose();
        this.display = null;
    }

    private void shutDownSwtDisplayThread() {
        Display display = this.getDisplay();
        display.wake();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }

    private void startSwtDisplayThread() {
        Runnable runnable = this.createShellRunnable();
        this.thread = new Thread(runnable, "SWT Display");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDisplay() {
        try {
            SwtDisplay swtDisplay = this;
            synchronized (swtDisplay) {
                while (this.getDisplay() == null) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            LogUtility.logError((Object)"SwtDisplay", (String)"Interrupted while waiting for display", (Throwable)e);
        }
    }
}

