/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.api.FaultInjection;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.TransactionImpl;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerAdapter;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.BranchXidDecision;
import com.sun.messaging.bridge.service.jms.tx.log.JDBCTxLogImpl;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.UID;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionManagerImpl
implements TransactionManager,
TransactionManagerAdapter {
    private static int FORMATID = 1246580992;
    private Logger _logger = null;
    private String _tmName = null;
    private static final int DEFAULT_MAX_BRANCHES = 16;
    private int _maxBranches = 16;
    private TMState _state = TMState.UNINITIALIZED;
    private Map<String, List<XAResource>> _rmToXAResources = new LinkedHashMap<String, List<XAResource>>();
    private ThreadLocal<TransactionImpl> _threadLocal = new ThreadLocal();
    private TxLog _txlog = null;
    private String _txlogType = "file";
    private String _txlogClass = null;
    private JMSBridgeStore _jdbcStore = null;
    private List<LogRecord> _recoveredLRs = new ArrayList<LogRecord>();
    private LinkedHashMap<String, ArrayList<String>> _keepGxidsForRM = new LinkedHashMap();
    private FaultInjection _fi = FaultInjection.getInjection();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    private boolean _sameXARSameRM = true;
    private static final int MAX_TMNAME_LENGTH = 55;
    private static final int MAX_RMNAME_LENGTH = 62;

    public void setJDBCStore(JMSBridgeStore store) throws IllegalStateException {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setJDBCStore");
        }
        this._jdbcStore = store;
    }

    @Override
    public synchronized void init(Properties props, boolean reset) throws Exception {
        if (this._logger == null) {
            throw new IllegalStateException("TM has no logger set");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            String name = null;
            String value = null;
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                value = props.getProperty(name);
                this._logger.log(Level.INFO, _jbr.getString("BSJ1054", name + "=" + value, this.getClass().getName()));
                this.setProperty(name, value);
            }
        }
        if (this._tmName == null) {
            throw new IllegalStateException("TM name not set for " + this.getClass().getName());
        }
        if (this._state != TMState.UNINITIALIZED) {
            this._logger.log(Level.WARNING, "init " + this);
            throw new IllegalStateException("init " + this);
        }
        if (this._txlogClass == null) {
            if (this._txlogType.equals("jdbc")) {
                this._txlog = (TxLog)Class.forName("com.sun.messaging.bridge.service.jms.tx.log.JDBCTxLogImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((JDBCTxLogImpl)this._txlog).setJDBCStore(this._jdbcStore);
            } else {
                this._txlog = (TxLog)Class.forName("com.sun.messaging.bridge.service.jms.tx.log.FileTxLogImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        } else {
            this._logger.log(Level.INFO, "loading txlog class " + this._txlogClass);
            this._txlog = (TxLog)Class.forName(this._txlogClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this._txlog.setLogger(this._logger);
        if (props.getProperty("txlogMaxBranches") == null) {
            props.setProperty("txlogMaxBranches", String.valueOf(this._maxBranches));
        }
        try {
            this._txlog.init(props, reset);
        }
        catch (Exception e) {
            this._txlog.close();
            throw e;
        }
        this._recoveredLRs = this._txlog.getAllLogRecords();
        this._logger.log(Level.INFO, _jbr.getString("BSJ1055", this._tmName, String.valueOf(this._recoveredLRs.size())));
        if (this._logger.isLoggable(Level.FINE)) {
            LogRecord lr2 = null;
            for (LogRecord lr2 : this._recoveredLRs) {
                this._logger.log(Level.INFO, "\t" + lr2 + "\n");
            }
        }
        this._state = TMState.INITIALIZED;
    }

    @Override
    public String[] getAllTransactions() throws Exception {
        if (this._state != TMState.INITIALIZED || this._txlog == null) {
            return null;
        }
        try {
            List lrs = this._txlog.getAllLogRecords();
            Iterator itr = lrs.iterator();
            String[] lrss = new String[lrs.size()];
            int i = 0;
            while (itr.hasNext()) {
                lrss[i++] = ((LogRecord)itr.next()).toString();
            }
            return lrss;
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Unable to get " + this + " all log records: " + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public TransactionManager getTransactionManager() throws SystemException {
        return this;
    }

    public void setProperty(String key, String value) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setProperty(" + key + ", " + value + ")");
        }
        if (key.equals("tmname")) {
            this.setName(value);
            return;
        }
        if (key.equals("txlogType")) {
            this.setTxlogType(value);
            return;
        }
        if (key.equals("txlogClass")) {
            this.setTxlogClass(value);
            return;
        }
        if (key.equals("jmsbridge")) {
            return;
        }
        if (key.equals("txSameXAResourceSameRM")) {
            this._sameXARSameRM = Boolean.valueOf(value);
            return;
        }
    }

    public void setName(String v) throws SystemException {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setName(" + v + ")");
        }
        if (v.getBytes().length > 55) {
            throw new SystemException("TM name " + v + " exceeds maximum 55 bytes");
        }
        this._tmName = v;
    }

    public void setTxlogType(String type) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setTxlogType(" + type + ")");
        }
        if (type == null || !type.trim().equals("file") && !type.trim().equals("jdbc")) {
            throw new IllegalArgumentException(this + ": Invalid txlog type " + type);
        }
        this._txlogType = type;
    }

    public void setTxlogClass(String cs) throws Exception {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setTxlogClass(" + cs + ")");
        }
        if (cs == null || cs.trim().length() == 0) {
            throw new IllegalArgumentException(this + ": Invalid txlog class " + cs);
        }
        Class<?> c = Class.forName(cs.trim());
        c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this._txlogClass = cs.trim();
    }

    public void setMaxBranches(int v) {
        if (this._state != TMState.UNINITIALIZED) {
            throw new IllegalStateException("setMaxBranches(" + v + ")");
        }
        if (v < 0 || v > 127) {
            throw new IllegalArgumentException("Invalid value " + v + " for maximum branches");
        }
        this._maxBranches = v;
    }

    protected int getMaxBranches() {
        return this._maxBranches;
    }

    @Override
    public boolean registerRM() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRM(String rmName, XAResource xaRes) throws Exception {
        if (this._state != TMState.INITIALIZED) {
            throw new IllegalStateException("TM not initialized");
        }
        if (rmName == null) {
            throw new SystemException("null RM name");
        }
        if (xaRes == null) {
            throw new SystemException("null XAResource object for RM " + rmName);
        }
        if (rmName.getBytes().length > 62) {
            throw new SystemException("RM name " + rmName + " exceeds maximum 62 bytes");
        }
        Map<String, List<XAResource>> map = this._rmToXAResources;
        synchronized (map) {
            List<XAResource> l = this._rmToXAResources.get(rmName);
            if (l == null) {
                l = new ArrayList<XAResource>();
                this._rmToXAResources.put(rmName, l);
            }
            for (XAResource xar : l) {
                if (!xar.isSameRM(xaRes) && !xaRes.isSameRM(xar) || xar.getClass().getName().equals(xaRes.getClass().getName())) continue;
                String emsg = "XAResource " + xaRes + " has different class name from what's registered " + xar + " for RM " + rmName;
                this._logger.log(Level.SEVERE, emsg);
                throw new IllegalArgumentException(emsg);
            }
            if (!l.contains(xaRes)) {
                l.add(xaRes);
            }
        }
        ArrayList<Xid[]> axids = new ArrayList<Xid[]>();
        Xid[] xidsr = null;
        int flag = 0x1000000;
        do {
            try {
                if (this._fi.FAULT_INJECTION) {
                    HashMap<String, String> p = new HashMap<String, String>();
                    p.put("cfref", rmName);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.recover.1", p, "javax.transaction.xa.XAException", true);
                }
                if ((xidsr = xaRes.recover(flag)).length > 0) {
                    flag = 0;
                }
                axids.add(xidsr);
            }
            catch (Throwable t) {
                this._logger.log(Level.SEVERE, "Recovering XAResource " + xaRes + " from RM " + rmName + " failed", t);
                SystemException ex = new SystemException(t.getMessage());
                ex.initCause(t);
                throw ex;
            }
        } while (xidsr.length > 0);
        ArrayList<String> rmNameKeepGxids = new ArrayList<String>();
        ArrayList<String> rmNameRealNames = new ArrayList<String>();
        BranchXid bxid = null;
        boolean commit = false;
        for (Xid[] xids : axids) {
            for (int i = 0; i < xids.length; ++i) {
                GlobalXid gxid;
                String rmn;
                block29: {
                    byte rmnlen;
                    byte tmnlen;
                    bxid = new BranchXid();
                    bxid.copy(xids[i]);
                    if (bxid.getFormatId() != FORMATID) {
                        this._logger.log(Level.WARNING, "Ignore foreign XID " + bxid + "[" + bxid.getFormatId() + "]");
                        continue;
                    }
                    byte[] gdata = bxid.getGlobalTransactionId();
                    String tmn = new String(gdata, 1, (int)(tmnlen = gdata[0]), "UTF-8");
                    if (!tmn.equals(this._tmName)) {
                        this._logger.log(Level.WARNING, "Ignore global XID " + bxid + " from different TM name [" + tmn + "] from mine [" + this._tmName + "]");
                        continue;
                    }
                    byte[] bdata = bxid.getBranchQualifier();
                    rmn = new String(bdata, 1, (int)(rmnlen = bdata[0]), "UTF-8");
                    if (!rmn.equals(rmName)) {
                        this._logger.log(Level.WARNING, "XID " + bxid + " from RM [" + rmName + "]" + xaRes + " has different RM name [" + rmn + "]");
                        rmNameRealNames.add(rmn);
                    }
                    commit = false;
                    gxid = new GlobalXid();
                    gxid.setFormatId(bxid.getFormatId());
                    gxid.setGlobalTransactionId(gdata);
                    this._logger.log(Level.INFO, "Recovering branch " + bxid + " for global transaction " + gxid + " from RM [" + rmName + "(" + rmn + ")]" + xaRes);
                    LogRecord lr = this._txlog.getLogRecord(gxid);
                    if (lr != null && lr.getGlobalDecision() == 0) {
                        commit = true;
                    }
                    try {
                        if (lr != null && lr.isHeuristicBranch(bxid)) {
                            this._logger.log(Level.WARNING, "Branch " + bxid + " was heuristically completed in " + gxid + "[" + commit + "]");
                            rmNameKeepGxids.add(gxid.toString());
                        }
                        break block29;
                    }
                    catch (NoSuchElementException e) {
                        rmNameKeepGxids.add(gxid.toString());
                        this._logger.log(Level.WARNING, "Unable to find branch " + bxid + " in " + lr + " for recovery");
                    }
                    continue;
                }
                XAParticipant party = new XAParticipant(rmn, xaRes, bxid, true);
                party.setLogger(this._logger);
                if (commit) {
                    try {
                        this._logger.log(Level.INFO, "Commiting recovered branch " + bxid + " to RM [" + rmName + "(" + rmn + ")]" + xaRes);
                        party.commit(false);
                    }
                    catch (Throwable t) {
                        rmNameKeepGxids.add(gxid.toString());
                        this._logger.log(Level.WARNING, "Failed to commit recovered branch " + bxid, t);
                    }
                    continue;
                }
                try {
                    this._logger.log(Level.INFO, "Rolling back recovered branch " + bxid + " to RM " + rmName);
                    party.rollback();
                    continue;
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Failed to rollback recovered branch " + bxid, t);
                }
            }
        }
        this.cleanupRecoveredLRs(rmName, rmNameKeepGxids, rmNameRealNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepGxidForRM(String gxid, String effectiveRM, String realRM) {
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = this._keepGxidsForRM;
        synchronized (linkedHashMap) {
            ArrayList<String> gxids;
            if (effectiveRM != null) {
                gxids = this._keepGxidsForRM.get(effectiveRM);
                if (gxids == null) {
                    gxids = new ArrayList();
                    this._keepGxidsForRM.put(effectiveRM, gxids);
                }
                if (gxid != null && !gxids.contains(gxid)) {
                    gxids.add(gxid);
                }
            }
            if (realRM != null) {
                gxids = this._keepGxidsForRM.get(realRM);
                if (gxids == null) {
                    gxids = new ArrayList();
                    this._keepGxidsForRM.put(realRM, gxids);
                }
                if (gxid != null && !gxids.contains(gxid)) {
                    gxids.add(gxid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupRecoveredLRs(String rmName, ArrayList<String> keepGxids, ArrayList<String> realRMNames) {
        this._logger.log(Level.INFO, _jbr.getString("BSJ1070", rmName, keepGxids.size()));
        this.keepGxidForRM(null, rmName, null);
        String realn2 = null;
        for (String realn2 : realRMNames) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1071", rmName, realn2));
            this.keepGxidForRM(null, null, realn2);
        }
        String gxid2 = null;
        for (String gxid2 : keepGxids) {
            this.keepGxidForRM(gxid2, rmName, null);
            for (String realn2 : realRMNames) {
                this.keepGxidForRM(gxid2, null, realn2);
            }
        }
        List<LogRecord> list = this._recoveredLRs;
        synchronized (list) {
            gxid2 = null;
            LogRecord lr = null;
            BranchXidDecision[] bxidds = null;
            Iterator<LogRecord> itr = this._recoveredLRs.iterator();
            while (itr.hasNext()) {
                lr = itr.next();
                gxid2 = lr.getGlobalXid().toString();
                bxidds = lr.getBranchXidDecisions();
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.INFO, "Check recovery completion for global xid " + gxid2);
                }
                BranchXid bxid = null;
                byte[] bq = null;
                byte len = 0;
                String rmn = null;
                boolean keep = false;
                for (int i = 0; i < bxidds.length; ++i) {
                    ArrayList<String> g;
                    bxid = bxidds[i].getBranchXid();
                    bq = bxid.getBranchQualifier();
                    len = bq[0];
                    try {
                        rmn = new String(bq, 1, (int)len, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this._logger.log(Level.WARNING, "Unable to get RM name from branch " + bxid.toString() + " for recovery global xid " + gxid2 + ": " + e.getMessage());
                        keep = true;
                        break;
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.INFO, "Check recovery completion for branch xid " + bxid + " with RM[" + rmn + "]");
                    }
                    if ((g = this._keepGxidsForRM.get(rmn)) == null || g.contains(gxid2)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            if (g == null) {
                                this._logger.log(Level.INFO, "Keep global xid " + gxid2 + " for no RM[" + rmn + "] info");
                            } else {
                                this._logger.log(Level.INFO, "Keep global xid " + gxid2 + " for RM[" + rmn + "]");
                            }
                        }
                        keep = true;
                        break;
                    }
                    if (!this._logger.isLoggable(Level.FINE)) continue;
                    this._logger.log(Level.INFO, "GXIDs " + g.size() + " to keep for RM[" + rmn + "]");
                    Iterator<String> gitr = g.iterator();
                    while (gitr.hasNext()) {
                        this._logger.log(Level.INFO, "GXIDs to keep for RM[" + rmn + "]: " + gitr.next());
                    }
                }
                if (keep) continue;
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1057", gxid2));
                    this._txlog.reap(gxid2);
                    itr.remove();
                }
                catch (Exception e) {
                    this._logger.log(Level.WARNING, "Unable to cleanup recovered global xid " + gxid2, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRM(String rmName) throws Exception {
        if (rmName == null) {
            throw new SystemException("null RM name");
        }
        Map<String, List<XAResource>> map = this._rmToXAResources;
        synchronized (map) {
            List<XAResource> l = this._rmToXAResources.get(rmName);
            if (l == null) {
                this._logger.log(Level.WARNING, "Removing a unknown RM " + rmName);
                return;
            }
            if (l.isEmpty()) {
                this._rmToXAResources.remove(rmName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRM(XAResource xaRes) throws Exception {
        Map<String, List<XAResource>> map = this._rmToXAResources;
        synchronized (map) {
            for (Map.Entry<String, List<XAResource>> pair : this._rmToXAResources.entrySet()) {
                List<XAResource> l = pair.getValue();
                for (XAResource xar : l) {
                    if (!xar.isSameRM(xaRes) && (!this._sameXARSameRM || xar != xaRes)) continue;
                    if (!xar.getClass().getName().equals(xaRes.getClass().getName())) {
                        this._logger.log(Level.WARNING, "XAResource " + xaRes + " has different class name from what's registered " + xar + " for RM " + pair.getKey());
                        continue;
                    }
                    return pair.getKey();
                }
            }
        }
        return null;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.checkState();
        TransactionImpl tx = this._threadLocal.get();
        if (tx != null) {
            throw new NotSupportedException("Nested transaction is not supported. The calling thread " + Thread.currentThread() + " is currently associated with transaction " + tx);
        }
        GlobalXid xid = this.genGlobalXid();
        tx = new TransactionImpl(xid, this);
        this._threadLocal.set(tx);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this._threadLocal.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        try {
            tx.commit();
        }
        finally {
            this._threadLocal.set(null);
            if (tx.getStatus() == 6) {
                // empty if block
            }
        }
    }

    @Override
    public int getStatus() throws SystemException {
        TransactionImpl tx = this._threadLocal.get();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        TransactionImpl tx = this._threadLocal.get();
        if (tx == null) {
            throw new SystemException("No transaction associated with calling thread " + Thread.currentThread());
        }
        return tx;
    }

    @Override
    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        throw new SystemException("operation not supported");
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this._threadLocal.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        try {
            tx.rollback();
        }
        finally {
            this._threadLocal.set(null);
        }
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx = this._threadLocal.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction associate with the calling thread " + Thread.currentThread());
        }
        tx.setRollbackOnly();
    }

    @Override
    public synchronized void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("operation not supported");
    }

    @Override
    public Transaction suspend() throws SystemException {
        throw new SystemException("operation not supported");
    }

    @Override
    public synchronized void shutdown() throws SystemException {
        if (this._state == TMState.CLOSED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1056", this.toString()));
            return;
        }
        this._state = TMState.CLOSING;
        try {
            this._txlog.close();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Failed to close txlog: ", e.getMessage());
            SystemException ex = new SystemException();
            ex.initCause(e);
            throw ex;
        }
        this._state = TMState.CLOSED;
    }

    private void checkState() throws SystemException {
        if (this._state == TMState.CLOSING || this._state == TMState.CLOSED) {
            throw new SystemException("TM is shuting down");
        }
    }

    private GlobalXid genGlobalXid() throws SystemException {
        try {
            GlobalXid xid = new GlobalXid();
            xid.setFormatId(FORMATID);
            byte[] tmn = this._tmName.getBytes("UTF-8");
            if (tmn.length > 55) {
                throw new SystemException("TM name " + this._tmName + " byte length exceeds 62");
            }
            UID uid = new UID();
            ByteBuffer bf = ByteBuffer.wrap(new byte[64]);
            bf.put((byte)tmn.length);
            bf.put(tmn);
            bf.putLong(uid.longValue());
            xid.setGlobalTransactionId(bf.array());
            return xid;
        }
        catch (Exception e) {
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            SystemException se = new SystemException(e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    protected BranchXid genBranchXid(GlobalXid xid, String rmName, String className, byte nth) throws SystemException {
        try {
            BranchXid bxid = new BranchXid();
            bxid.copy(xid);
            byte[] rn = rmName.getBytes("UTF-8");
            if (rn.length > 62) {
                throw new SystemException("Resource manager name " + rmName + " byte length exceeds 62");
            }
            int cnlen = 62 - rn.length;
            byte[] cn = className.getBytes("UTF-8");
            if (cnlen > cn.length) {
                cnlen = cn.length;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.INFO, "genBranchXid:rmName=" + rmName + "[" + rn.length + "], className=" + className + "[" + cnlen + "]");
            }
            ByteBuffer bf = ByteBuffer.wrap(new byte[64]);
            bf.put((byte)rn.length);
            bf.put(rn);
            bf.put(cn, 0, cnlen);
            bf.put(nth);
            bxid.setBranchQualifier(bf.array());
            return bxid;
        }
        catch (Exception e) {
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            SystemException se = new SystemException(e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    public TxLog getTxLog() {
        return this._txlog;
    }

    private static String stateString(TMState s) {
        switch (s) {
            case UNINITIALIZED: {
                return "UNINITIALIZED";
            }
            case INITIALIZED: {
                return "INITIALIZED";
            }
            case CLOSING: {
                return "CLOSING";
            }
            case CLOSED: {
                return "CLOSED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "TM:" + this._tmName + "[" + TransactionManagerImpl.stateString(this._state) + "]";
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    private static enum TMState {
        UNINITIALIZED,
        INITIALIZED,
        CLOSING,
        CLOSED;

    }
}

