/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.client;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.client.HttpTunnelPush;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpTunnelClientDriver
extends Thread
implements HttpTunnelDefaults,
HttpTunnelDriver {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private boolean stopThread = false;
    private String urlString = null;
    private String urlParam = null;
    private URL pushUrl = null;
    private URL pullUrl = null;
    private URLConnection uc = null;
    private HttpTunnelPush pushWorker = null;
    private int connId;
    private HttpTunnelConnection conn = null;
    private long lastConnectTime = 0L;
    private Logger logger = Logger.getLogger("Http Tunneling");

    public HttpTunnelClientDriver(String urlString) {
        int index = urlString.lastIndexOf(63);
        if (index >= 0) {
            this.urlString = urlString.substring(0, index);
            this.urlParam = "&" + urlString.substring(index + 1);
        } else {
            this.urlString = urlString;
            this.urlParam = "";
        }
        this.setName("HttpTunnelClientDriver");
        this.setDaemon(true);
        this.pushWorker = new HttpTunnelPush();
    }

    private void handleConnInitAck() {
        if (this.conn != null) {
            return;
        }
        this.conn = new HttpTunnelConnection(this.connId, this);
    }

    private void handleConnClose(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleClose(p);
    }

    private void handleConnAbort(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleAbort(p);
    }

    private void handleConnOption(HttpTunnelPacket p) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleConnOption(p);
    }

    private void handlePacket(HttpTunnelPacket p, boolean moreData) {
        if (this.conn == null) {
            return;
        }
        this.conn.receivePacket(p, moreData);
    }

    private void handleDummyPacket(HttpTunnelPacket p) {
        if (DEBUG) {
            this.log("#### Received dummy packet :");
            this.log(p + "\n");
        }
    }

    public HttpTunnelConnection doConnect() throws IOException {
        URL connUrl = new URL(this.urlString + "?Type=connect" + this.urlParam);
        HttpTunnelPacket p = new HttpTunnelPacket();
        p.setPacketType(1);
        p.setPacketBody(null);
        p.setConnId(0);
        p.setSequence(0);
        p.setWinsize(0);
        p.setChecksum(0);
        try {
            HttpTunnelPacket resp = this.pushWorker.sendPacketDirect(connUrl, p, true);
            this.connId = resp.getConnId();
            String serverName = new String(resp.getPacketBody(), "UTF8");
            String newurlParam = "&" + serverName;
            if (!this.urlParam.equals("") && !newurlParam.equals(this.urlParam)) {
                throw new IOException("Unexpected new ServerName: " + serverName);
            }
            if (this.urlParam.equals("")) {
                this.urlParam = newurlParam;
            }
            this.pushUrl = new URL(this.urlString + "?Type=push" + this.urlParam);
            this.pullUrl = new URL(this.urlString + "?Type=pull&ConnId=" + this.connId + this.urlParam);
            while (this.conn == null) {
                HttpTunnelPacket ack;
                Vector v = this.pullPackets();
                if (v == null || v.isEmpty() || (ack = (HttpTunnelPacket)v.elementAt(0)) == null) continue;
                switch (ack.getPacketType()) {
                    case 7: {
                        throw new IOException("Connection refused");
                    }
                    case 2: {
                        this.handleConnInitAck();
                        break;
                    }
                    case 5: {
                        this.handleConnClose(p);
                    }
                }
            }
        }
        catch (Exception e) {
            Object message = "Connection refused : ";
            if (e instanceof EOFException) {
                message = "Connection refused : Make sure that the broker is running and its HTTP service is active...";
            }
            if (e.getMessage() != null) {
                message = (String)message + e.getMessage();
            }
            ConnectException ce = new ConnectException((String)message);
            try {
                ce.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw ce;
        }
        this.pushWorker.startPushThread(this.pushUrl);
        this.start();
        return this.conn;
    }

    @Override
    public void sendPacket(HttpTunnelPacket p) {
        this.pushWorker.sendPacket(p);
        if (DEBUG) {
            this.log("Sending packet" + p);
        }
    }

    @Override
    public void shutdown(int connId) {
        this.pushWorker.shutdown();
        this.stopThread = true;
        if (this.uc != null && this.uc instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)this.uc).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.conn = null;
    }

    private Vector pullPackets() throws Exception {
        Vector<HttpTunnelPacket> v = null;
        int responseCode = 200;
        try {
            this.uc = this.pullUrl.openConnection();
            this.uc.setDoInput(true);
            this.uc.setDoOutput(false);
            this.uc.setUseCaches(false);
            this.uc.connect();
            if (this.uc instanceof HttpURLConnection) {
                responseCode = ((HttpURLConnection)this.uc).getResponseCode();
            } else {
                this.uc.getContentType();
            }
        }
        catch (IOException e) {
            this.handleHTTPConnectError();
            throw e;
        }
        if (responseCode != 200) {
            this.handleHTTPConnectError();
        } else {
            this.lastConnectTime = System.currentTimeMillis();
            v = new Vector<HttpTunnelPacket>();
            InputStream is = this.uc.getInputStream();
            try {
                while (true) {
                    HttpTunnelPacket p = new HttpTunnelPacket();
                    p.readPacket(is);
                    v.addElement(p);
                }
            }
            catch (Exception e) {
                HttpTunnelPacket p;
                if (v.size() <= 1 && (v.size() != 1 || (p = (HttpTunnelPacket)v.elementAt(0)).getPacketType() == 12)) {
                    int pullPeriod = this.conn.getPullPeriod();
                    if (pullPeriod > 0) {
                        try {
                            Thread.sleep((long)pullPeriod * 1000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        throw e;
                    }
                }
                is.close();
            }
        }
        this.uc = null;
        return v;
    }

    private void handleHTTPConnectError() {
        if (this.conn.getConnectionTimeout() <= 0) {
            return;
        }
        if (this.lastConnectTime == 0L) {
            return;
        }
        if (System.currentTimeMillis() - this.lastConnectTime > (long)this.conn.getConnectionTimeout() * 1000L) {
            HttpTunnelPacket p = new HttpTunnelPacket();
            p.setPacketType(9);
            p.setConnId(this.connId);
            p.setSequence(0);
            p.setWinsize(0);
            p.setChecksum(0);
            p.setPacketBody(null);
            this.handleConnAbort(p);
        }
    }

    private void handleHttpPullError() {
    }

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                HttpTunnelPacket p;
                int j;
                Vector v = this.pullPackets();
                if (v == null || v.isEmpty()) {
                    this.handleHttpPullError();
                    continue;
                }
                for (j = v.size() - 1; j >= 0 && (p = (HttpTunnelPacket)v.elementAt(j)).getPacketType() != 4; --j) {
                }
                block13: for (int i = 0; i < v.size(); ++i) {
                    p = (HttpTunnelPacket)v.elementAt(i);
                    if (p.getPacketType() == 7) {
                        // empty if block
                    }
                    if (DEBUG) {
                        this.log("Received packet:" + p);
                    }
                    switch (p.getPacketType()) {
                        case 5: {
                            this.handleConnClose(p);
                            continue block13;
                        }
                        case 9: {
                            this.handleConnAbort(p);
                            continue block13;
                        }
                        case 10: {
                            this.handleConnOption(p);
                            continue block13;
                        }
                        case 4: 
                        case 6: {
                            this.handlePacket(p, i != j);
                            continue block13;
                        }
                        case 100: {
                            this.handleDummyPacket(p);
                            continue block13;
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.handleHttpPullError();
            }
        }
    }

    @Override
    public Hashtable getDebugState() {
        return new Hashtable();
    }

    private void log(String msg) {
        this.logger.log(Level.INFO, msg);
    }
}

