/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.config;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.config.WatchedProperty;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateProperties
extends Properties {
    private static final long serialVersionUID = 2654468190051766351L;
    private Logger logger = CommGlobals.getLogger();
    protected Properties storedprops = new Properties();
    protected String storedloc = null;
    private static final String PROP_HEADER_STR = "#This file is automatically generated, DO NOT EDIT";

    public UpdateProperties() {
        super(System.getProperties());
    }

    public void loadStoredPropertiesFile(String location) throws IOException, IllegalArgumentException {
        this.setStoredPropertiesLocation(location);
        Properties props = this.readPropertiesFile(location);
        this.setStoredProperties(props);
    }

    protected void setStoredProperties(Properties props) throws IllegalArgumentException {
        this.putAll((Map)props);
        this.storedprops.putAll((Map<?, ?>)props);
    }

    protected void setStoredPropertiesLocation(String location) throws IllegalArgumentException {
        if (this.storedloc != null) {
            throw new IllegalArgumentException(CommGlobals.getBrokerResources().getString("B4117", "Can not access more than one stored property location"));
        }
        if (location == null) {
            throw new IllegalArgumentException(CommGlobals.getBrokerResources().getString("B4117", "Can not load property from null location"));
        }
        this.storedloc = location;
    }

    @Override
    public Object put(Object name, Object value) {
        Object o = super.get(name);
        Object retobj = null;
        if (o instanceof WatchedProperty) {
            WatchedProperty wp = (WatchedProperty)o;
            retobj = wp.getValue();
            wp.setValue((String)value);
        } else {
            retobj = super.put(name, value);
        }
        return retobj;
    }

    @Override
    public Object remove(Object key) {
        Object o = super.get(key);
        Object retobj = null;
        if (o instanceof WatchedProperty) {
            WatchedProperty wp = (WatchedProperty)o;
            retobj = wp.getValue();
            wp.setValue(null);
        } else {
            retobj = super.remove(key);
        }
        return retobj;
    }

    public void loadDefaultProperties(String location) throws IOException {
        this.readPropertiesFile(location, this);
    }

    protected Properties readPropertiesFile(String location) throws IOException {
        Properties props = new Properties();
        this.readPropertiesFile(location, props);
        return props;
    }

    protected void readPropertiesFile(String location, Properties props) throws IOException {
        FileInputStream ifile = new FileInputStream(location);
        BufferedInputStream bfile = new BufferedInputStream(ifile);
        props.load(bfile);
        bfile.close();
        ifile.close();
    }

    private synchronized void saveUpdatedProperties() throws IOException {
        this.saveUpdatedProperties(this.storedprops);
    }

    protected void saveUpdatedProperties(Properties props) throws IOException {
        FileOutputStream cfile = new FileOutputStream(this.storedloc);
        BufferedOutputStream bos = new BufferedOutputStream(cfile);
        props.store(bos, PROP_HEADER_STR);
        bos.close();
        cfile.close();
    }

    @Override
    public void putAll(Map props) {
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Object prop = super.get(key);
            if (prop == null || !(prop instanceof WatchedProperty)) {
                super.setProperty(key, value);
                continue;
            }
            ((WatchedProperty)prop).setValue(value);
        }
    }

    public void updateProperty(String key, String value) throws PropertyUpdateException, IOException {
        this.updateProperty(key, value, true);
    }

    public void updateBooleanProperty(String key, boolean value, boolean save) throws PropertyUpdateException, IOException {
        this.updateProperty(key, Boolean.valueOf(value).toString(), save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String key, String value, boolean save) throws PropertyUpdateException, IOException {
        Object prop = super.get(key);
        if (prop instanceof WatchedProperty) {
            Vector listeners = ((WatchedProperty)prop).getListeners();
            if (listeners != null) {
                Vector vector = listeners;
                synchronized (vector) {
                    int i;
                    for (i = 0; i < listeners.size(); ++i) {
                        ((ConfigListener)listeners.elementAt(i)).validate(key, value);
                    }
                    for (i = 0; i < listeners.size(); ++i) {
                        ((ConfigListener)listeners.elementAt(i)).update(key, value);
                    }
                }
            }
            ((WatchedProperty)prop).setValue(value);
        } else {
            super.setProperty(key, value);
        }
        this.storedprops.setProperty(key, value);
        if (save) {
            this.saveUpdatedProperties();
        }
    }

    public void updateRemoveProperty(String key, boolean save) throws IOException {
        super.remove(key);
        this.storedprops.remove(key);
        if (save) {
            this.saveUpdatedProperties();
        }
    }

    public void updateProperties(Hashtable values) throws PropertyUpdateException, IOException {
        this.updateProperties(values, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Hashtable values, boolean save) throws PropertyUpdateException, IOException {
        int i;
        Vector vector;
        String key;
        Enumeration _enum = values.keys();
        while (_enum.hasMoreElements()) {
            Vector listeners;
            key = (String)_enum.nextElement();
            String value = (String)values.get(key);
            Object prop = super.get(key);
            if (!(prop instanceof WatchedProperty) || (listeners = ((WatchedProperty)prop).getListeners()) == null) continue;
            vector = listeners;
            synchronized (vector) {
                for (i = 0; i < listeners.size(); ++i) {
                    ((ConfigListener)listeners.get(i)).validate(key, value);
                }
            }
        }
        this.putAll((Map)values);
        this.storedprops.putAll((Map<?, ?>)values);
        _enum = values.keys();
        while (_enum.hasMoreElements()) {
            key = (String)_enum.nextElement();
            Object prop = super.get(key);
            if (prop == null || !(prop instanceof WatchedProperty)) continue;
            Vector listeners = ((WatchedProperty)prop).getListeners();
            String value = (String)values.get(key);
            if (listeners == null) continue;
            vector = listeners;
            synchronized (vector) {
                for (i = 0; i < listeners.size(); ++i) {
                    ((ConfigListener)listeners.elementAt(i)).update(key, value);
                }
            }
        }
        if (save) {
            this.saveUpdatedProperties();
        }
    }

    @Override
    public String getProperty(String key) {
        Object prop = super.get(key);
        if (prop == null) {
            return null;
        }
        if (prop instanceof WatchedProperty) {
            return ((WatchedProperty)prop).getValue();
        }
        if (prop instanceof String) {
            return (String)prop;
        }
        return null;
    }

    @Override
    public String getProperty(String key, String default_value) {
        String prop = this.getProperty(key);
        if (prop == null) {
            return default_value;
        }
        return prop;
    }

    @Override
    public void list(PrintStream out) {
        out.println("-- listing properties --");
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = super.get(key);
            Object valstr = val.toString();
            if (((String)valstr).length() > 60) {
                valstr = ((String)valstr).substring(0, 57) + "...";
            }
            out.println(key + "=" + (String)valstr);
        }
    }

    @Override
    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = super.get(key);
            Object valstr = val.toString();
            if (((String)valstr).length() > 60) {
                valstr = ((String)valstr).substring(0, 57) + "...";
            }
            out.println(key + "=" + (String)valstr);
        }
    }

    public List getPropertyNames(String namePrefix) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            list.add(key);
        }
        return list;
    }

    public void addListener(String name, ConfigListener listener) {
        Object prop = super.get(name);
        WatchedProperty watcher = null;
        if (prop == null || prop instanceof String) {
            watcher = new WatchedProperty((String)prop);
            super.put(name, watcher);
        } else {
            watcher = (WatchedProperty)prop;
        }
        watcher.addListener(listener);
    }

    public void removeListener(String name, ConfigListener listener) {
        Object prop = super.get(name);
        if (prop instanceof WatchedProperty) {
            WatchedProperty watcher = (WatchedProperty)prop;
            watcher.removeListener(listener);
        }
    }

    public List getList(String name) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(prop, ",", false);
        ArrayList<String> retv = new ArrayList<String>();
        while (token.hasMoreElements()) {
            int start;
            String newtoken = token.nextToken();
            newtoken = newtoken.trim();
            for (start = 0; start < newtoken.length() && Character.isSpaceChar(newtoken.charAt(start)); ++start) {
            }
            if (start > 0) {
                newtoken = newtoken.substring(start + 1);
            }
            if (newtoken.length() <= 0) continue;
            retv.add(newtoken);
        }
        return retv;
    }

    public String[] getArray(String name) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(prop, ",", false);
        int num = token.countTokens();
        String[] retv = new String[num];
        for (int i = 0; i < num; ++i) {
            int start;
            String newtoken = token.nextToken();
            newtoken = newtoken.trim();
            for (start = 0; start < newtoken.length() && Character.isSpaceChar(newtoken.charAt(start)); ++start) {
            }
            if (start > 0) {
                newtoken = newtoken.substring(start + 1);
            }
            retv[i] = newtoken;
        }
        return retv;
    }

    public long getLongProperty(String name) {
        return this.getLongProperty(name, 0L);
    }

    public long getLongProperty(String name, long defval) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return defval;
        }
        try {
            return Long.parseLong(prop);
        }
        catch (Exception ex) {
            this.logger.log(8, "B3138", (Object)name, (Throwable)ex);
            return defval;
        }
    }

    public float getPercentageProperty(String name, float defval) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return defval;
        }
        try {
            return Float.parseFloat(prop) / 100.0f;
        }
        catch (Exception ex) {
            this.logger.log(8, "B3138", (Object)name, (Throwable)ex);
            return defval;
        }
    }

    public int getIntProperty(String name) {
        return this.getIntProperty(name, 0);
    }

    public int getIntProperty(String name, int defval) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return defval;
        }
        try {
            return Integer.parseInt(prop);
        }
        catch (Exception ex) {
            this.logger.log(8, "B3138", (Object)name, (Throwable)ex);
            return defval;
        }
    }

    public SizeString getSizeProperty(String name) {
        return this.getSizeProperty(name, 0L);
    }

    public SizeString getSizeProperty(String name, long defval) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return new SizeString(defval);
        }
        try {
            return new SizeString(prop);
        }
        catch (Exception ex) {
            this.logger.log(8, "B3138", (Object)name, (Throwable)ex);
            return new SizeString(defval);
        }
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defval) {
        String prop = this.getProperty(name);
        if (prop == null) {
            return defval;
        }
        try {
            return Boolean.parseBoolean(prop);
        }
        catch (Exception ex) {
            this.logger.log(8, "B3138", (Object)name, (Throwable)ex);
            return defval;
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        Enumeration<Object> e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = this.getProperty(key);
            if (val == null) {
                val = "";
            }
            props.setProperty(key, val);
        }
        return props;
    }
}

