/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionClosedListener;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestrictionListener;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimerTask;

class MasterBrokerWaiter
extends Thread
implements ServiceRestrictionListener,
ConnectionClosedListener {
    static Logger logger = Globals.getLogger();
    static final long waitinterval = 15000L;
    static final int DEFAULT_MAXWAIT = 90;
    static long maxwait = (long)Globals.getConfig().getIntProperty("imq.cluster.nowaitForMasterBrokerTimeoutInSeconds", 90) * 1000L;
    static MasterBrokerWaiter waiter = null;
    static ErrHandler defaultHandler = null;
    Object lock = new Object();
    ArrayList<Request> requests = new ArrayList();
    boolean notified = false;

    MasterBrokerWaiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceRestrictionChanged(Service s) {
        Object object = this.lock;
        synchronized (object) {
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(Connection con) {
        if (PacketHandler.getDEBUG()) {
            logger.log(8, "MasterBrokerWaiter.connectionClosed(): " + con);
        }
        Object object = this.lock;
        synchronized (object) {
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNotify(long timeout, boolean log) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.notified && !this.requests.isEmpty()) {
                if (log) {
                    logger.log(8, Globals.getBrokerResources().getKString("B1349", Thread.currentThread().getName(), timeout / 1000L + "[" + maxwait / 1000L + "]"));
                }
                this.lock.wait(timeout);
            }
            this.notified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addRequest(Packet pkt, IMQConnection con, String retrymsg, String errmsg, ErrHandler defh) {
        if (maxwait == 0L) {
            return false;
        }
        Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
        synchronized (MasterBrokerWaiter.class) {
            if (defaultHandler == null) {
                defaultHandler = defh;
            }
            boolean started = true;
            if (waiter == null) {
                waiter = new MasterBrokerWaiter();
                waiter.setDaemon(true);
                waiter.setName("MQ-mbwaiter");
                started = false;
            }
            waiter.addRequest(pkt, con, retrymsg, errmsg);
            if (!started) {
                waiter.start();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTimedout(Request rq) {
        Object object = this.lock;
        synchronized (object) {
            rq.timedout = true;
            this.notified = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(Packet pkt, IMQConnection con, String retrymsg, String errmsg) {
        Request rq = new Request();
        PacketInfo pi = new PacketInfo();
        pi.sendack = pkt.getSendAcknowledge();
        pi.pktype = pkt.getPacketType();
        pi.consumerID = pkt.getConsumerID();
        rq.pi = pi;
        rq.con = con;
        rq.service = con.getService();
        rq.retrymsg = retrymsg;
        rq.errmsg = errmsg;
        rq.service.addServiceRestrictionListener(this);
        rq.con.addConnectionClosedListener(this);
        Object object = this.lock;
        synchronized (object) {
            this.requests.add(rq);
            this.lock.notifyAll();
        }
        if (maxwait > 0L) {
            rq.timertask = new TimeoutTimerTask(this, rq);
            Globals.getTimer().schedule((TimerTask)rq.timertask, maxwait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(Request rq) {
        Object object = this.lock;
        synchronized (object) {
            this.requests.remove(rq);
        }
        rq.service.removeServiceRestrictionListener(this);
        rq.con.removeConnectionClosedListener(this);
        if (rq.timertask != null) {
            rq.timertask.cancel();
        }
    }

    public void sendRetry(ArrayList rqs) {
        Iterator itr = rqs.iterator();
        Request rq = null;
        while (itr.hasNext()) {
            rq = (Request)itr.next();
            defaultHandler.sendError(rq.con, rq.pi.sendack, rq.pi.pktype, rq.pi.consumerID, rq.retrymsg, 449);
        }
    }

    public void sendError(ArrayList rqs) {
        Iterator itr = rqs.iterator();
        Request rq = null;
        while (itr.hasNext()) {
            rq = (Request)itr.next();
            defaultHandler.sendError(rq.con, rq.pi.sendack, rq.pi.pktype, rq.pi.consumerID, rq.errmsg, 503);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Request[] rqs;
        long logtime = 0L;
        long currtime = System.currentTimeMillis();
        long timewaited = 0L;
        block16: while (true) {
            ServiceRestriction[] srs;
            Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            Object object = this.lock;
            // MONITORENTER : object
            if (this.requests.isEmpty()) {
                waiter = null;
                logger.log(8, Globals.getBrokerResources().getKString("B1358", "[" + Thread.currentThread().getName() + "]"));
                // MONITOREXIT : object
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : object
            // MONITOREXIT : clazz
            ArrayList<Request> retrys = new ArrayList<Request>();
            ArrayList<Request> errors = new ArrayList<Request>();
            rqs = null;
            Class<MasterBrokerWaiter> clazz2 = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            Object object2 = this.lock;
            // MONITORENTER : object2
            rqs = this.requests.toArray(new Request[this.requests.size()]);
            // MONITOREXIT : object2
            // MONITOREXIT : clazz2
            if (rqs != null) {
                for (int i = 0; i < rqs.length; ++i) {
                    if (rqs[i].con.getConnectionState() >= 6) {
                        this.removeRequest(rqs[i]);
                    }
                    if (maxwait < 0L) {
                        rqs[i].totalwaited = 0L;
                    } else if (rqs[i].totalwaited >= maxwait || rqs[i].timedout) {
                        errors.add(rqs[i]);
                        this.removeRequest(rqs[i]);
                    }
                    srs = rqs[i].service.getServiceRestrictions();
                    if (srs == null) {
                        retrys.add(rqs[i]);
                        this.removeRequest(rqs[i]);
                    } else {
                        boolean found = false;
                        for (int j = 0; j < srs.length; ++j) {
                            if (srs[j] != ServiceRestriction.NO_SYNC_WITH_MASTERBROKER) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            retrys.add(rqs[i]);
                            this.removeRequest(rqs[i]);
                        }
                    }
                    rqs[i].con.updateAccessTime(true);
                }
            }
            this.sendRetry(retrys);
            this.sendError(errors);
            boolean log = false;
            if (currtime - logtime > 15000L) {
                log = true;
                logtime = currtime;
            }
            srs = this.lock;
            // MONITORENTER : this.lock
            rqs = this.requests.toArray(new Request[this.requests.size()]);
            this.waitForNotify(15000L, log);
            // MONITOREXIT : srs
            long precurrtime = currtime;
            currtime = System.currentTimeMillis();
            timewaited = currtime - precurrtime > 0L ? currtime - precurrtime : 0L;
            int i = 0;
            while (true) {
                if (i >= rqs.length) continue block16;
                rqs[i].totalwaited += timewaited;
                ++i;
            }
            break;
        }
        catch (InterruptedException ex) {
            logger.log(8, Globals.getBrokerResources().getKString("B1350", Thread.currentThread().getName()));
            ArrayList<Request> all = new ArrayList<Request>();
            Class<MasterBrokerWaiter> clazz = MasterBrokerWaiter.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.data.MasterBrokerWaiter.class
            Object object = this.lock;
            // MONITORENTER : object
            rqs = this.requests.toArray(new Request[this.requests.size()]);
            int i = 0;
            while (true) {
                if (i >= rqs.length) {
                    // MONITOREXIT : object
                    waiter = null;
                    // MONITOREXIT : clazz
                    this.sendError(all);
                    logger.log(8, Globals.getBrokerResources().getKString("B1358", "[" + Thread.currentThread().getName() + "]"));
                    return;
                }
                this.removeRequest(rqs[i]);
                all.add(rqs[i]);
                ++i;
            }
        }
    }

    static class TimeoutTimerTask
    extends TimerTask {
        MasterBrokerWaiter waiter = null;
        Request rq = null;

        TimeoutTimerTask(MasterBrokerWaiter waiter, Request rq) {
            this.waiter = waiter;
            this.rq = rq;
        }

        @Override
        public void run() {
            this.waiter.requestTimedout(this.rq);
        }
    }

    static class PacketInfo {
        boolean sendack;
        int pktype;
        long consumerID;

        PacketInfo() {
        }
    }

    static class Request {
        PacketInfo pi = null;
        IMQConnection con = null;
        Service service = null;
        long totalwaited = 0L;
        String errmsg = "";
        String retrymsg = "";
        TimeoutTimerTask timertask = null;
        boolean timedout = false;

        Request() {
        }
    }
}

