/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import com.sun.messaging.jms.management.server.BrokerNotification;
import com.sun.messaging.jms.management.server.BrokerState;
import com.sun.messaging.jms.management.server.ClusterNotification;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ClusterMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getBrokerInfoByAddrSignature;
    private static MBeanParameterInfo[] getBrokerInfoByIdSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] clsNotificationTypes;
    private static String[] brokerNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private static final String[] brokerInfoItemNames;
    private static final String[] brokerInfoItemDesc;
    private static final OpenType[] itemTypes;
    private CompositeType compType = null;

    public String getConfigFileURL() {
        Properties brokerProps = Globals.getConfig().toProperties();
        return brokerProps.getProperty("imq.cluster.url");
    }

    public String getClusterID() {
        return Globals.getClusterID();
    }

    public Boolean isHighlyAvailable() {
        return this.getHighlyAvailable();
    }

    public Boolean getHighlyAvailable() {
        return Globals.getHAEnabled();
    }

    public Boolean isUseSharedDatabaseForConfigRecord() {
        return this.getUseSharedDatabaseForConfigRecord();
    }

    public Boolean getUseSharedDatabaseForConfigRecord() {
        return Globals.useSharedConfigRecord();
    }

    public CompositeData getLocalBrokerInfo() throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        MQAddress address = cm.getMQAddress();
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(address.toString()));
        }
        catch (Exception e) {
            this.handleGetterException("LocalBrokerInfo", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = this.getCompositeData(cb);
        }
        catch (Exception e) {
            this.handleGetterException("LocalBrokerInfo", e);
        }
        return cd;
    }

    public String getMasterBroker() {
        Properties brokerProps = Globals.getConfig().toProperties();
        return brokerProps.getProperty("imq.cluster.masterbroker");
    }

    public CompositeData getMasterBrokerInfo() throws MBeanException {
        if (Globals.getHAEnabled()) {
            return null;
        }
        if (Globals.useSharedConfigRecord()) {
            return null;
        }
        String mbAddr = this.getMasterBroker();
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(mbAddr));
        }
        catch (Exception e) {
            this.handleGetterException("MasterBrokerInfo", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = this.getCompositeData(cb);
        }
        catch (Exception e) {
            this.handleGetterException("MasterBrokerInfo", e);
        }
        return cd;
    }

    public String[] getBrokerAddresses() {
        return this.getBrokerIDsOrAddresses(false);
    }

    public String[] getBrokerIDs() {
        if (!Globals.getHAEnabled()) {
            return null;
        }
        return this.getBrokerIDsOrAddresses(true);
    }

    private String[] getBrokerIDsOrAddresses(boolean getID) {
        ClusterManager cm = Globals.getClusterManager();
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        if (cm == null) {
            return null;
        }
        Iterator itr = cm.getKnownBrokers(true);
        if (itr == null) {
            return null;
        }
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            Hashtable bkrInfo = GetClusterHandler.getBrokerClusterInfo(cb, this.logger);
            if (bkrInfo == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            String idOrAddress = getID ? (String)bkrInfo.get("ID") : (String)bkrInfo.get("Address");
            if (idOrAddress == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            al.add(idOrAddress);
        }
        list = new String[al.size()];
        list = al.toArray(list);
        return list;
    }

    public CompositeData[] getBrokerInfo() throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData[] cds = null;
        ArrayList<CompositeData> al = new ArrayList<CompositeData>();
        if (cm == null) {
            return null;
        }
        Iterator itr = cm.getKnownBrokers(true);
        if (itr == null) {
            return null;
        }
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            try {
                CompositeData cd = this.getCompositeData(cb);
                al.add(cd);
            }
            catch (Exception e) {
                this.handleOperationException("getBrokerInfo", e);
            }
        }
        cds = new CompositeData[al.size()];
        cds = al.toArray(cds);
        return cds;
    }

    public CompositeData getBrokerInfoByAddress(String address) throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(address));
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByAddress", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = this.getCompositeData(cb);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByAddress", e);
        }
        return cd;
    }

    public CompositeData getBrokerInfoByID(String id) throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (!Globals.getHAEnabled()) {
            return null;
        }
        try {
            if (cm == null) {
                return null;
            }
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = this.getCompositeData(cb);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByID", e);
        }
        return cd;
    }

    private CompositeData getCompositeData(ClusteredBroker cb) throws OpenDataException {
        CompositeDataSupport cds = null;
        Hashtable bkrInfo = GetClusterHandler.getBrokerClusterInfo(cb, this.logger);
        String id = null;
        if (Globals.getHAEnabled()) {
            id = (String)bkrInfo.get("ID");
        }
        Object[] brokerInfoItemValues = new Object[]{bkrInfo.get("Address"), id, bkrInfo.get("State"), BrokerState.toString((Integer)bkrInfo.get("State")), bkrInfo.get("NumMsgs"), bkrInfo.get("TakeoverBrokerID"), bkrInfo.get("StatusTimestamp")};
        if (this.compType == null) {
            this.compType = new CompositeType("BrokerClusterInfo", "BrokerClusterInfo", brokerInfoItemNames, brokerInfoItemDesc, itemTypes);
        }
        cds = new CompositeDataSupport(this.compType, brokerInfoItemNames, brokerInfoItemValues);
        return cds;
    }

    @Override
    public String getMBeanName() {
        return "ClusterMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1020");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyTakeoverStart(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.start", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        try {
            CompositeData cd = this.getLocalBrokerInfo();
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        catch (MBeanException e) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification mq.broker.takeover.start");
        }
        this.sendNotification(n);
    }

    public void notifyTakeoverComplete(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.complete", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        try {
            CompositeData cd = this.getLocalBrokerInfo();
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        catch (MBeanException e) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification mq.broker.takeover.complete");
        }
        this.sendNotification(n);
    }

    public void notifyTakeoverFail(String brokerID) {
        BrokerNotification n = new BrokerNotification("mq.broker.takeover.fail", this, this.sequenceNumber++);
        n.setFailedBrokerID(brokerID);
        try {
            CompositeData cd = this.getLocalBrokerInfo();
            n.setBrokerAddress((String)cd.get("Address"));
            n.setBrokerID((String)cd.get("ID"));
        }
        catch (MBeanException e) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification mq.broker.takeover.fail");
        }
        this.sendNotification(n);
    }

    public void notifyClusterBrokerDown(String brokerID) {
        ClusterNotification n = new ClusterNotification("mq.cluster.broker.down", this, this.sequenceNumber++);
        n.setBrokerAddress(ClusterUtil.getShortBrokerAddress(brokerID));
        n.setHighlyAvailable(Globals.getHAEnabled());
        if (n.isHighlyAvailable()) {
            n.setClusterID(Globals.getClusterID());
            n.setBrokerID(brokerID);
        } else {
            n.setMasterBroker(ClusterUtil.isMasterBroker(n.getBrokerAddress()));
        }
        this.sendNotification(n);
    }

    public void notifyClusterBrokerJoin(String brokerID) {
        ClusterNotification n = new ClusterNotification("mq.cluster.broker.join", this, this.sequenceNumber++);
        n.setBrokerAddress(ClusterUtil.getShortBrokerAddress(brokerID));
        n.setHighlyAvailable(Globals.getHAEnabled());
        if (n.isHighlyAvailable()) {
            n.setClusterID(Globals.getClusterID());
            n.setBrokerID(brokerID);
        } else {
            n.setMasterBroker(ClusterUtil.isMasterBroker(n.getBrokerAddress()));
        }
        this.sendNotification(n);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[6];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConfigFileURL", String.class.getName(), mbr.getString("MB1002"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClusterID", String.class.getName(), mbr.getString("MB1003"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("HighlyAvailable", Boolean.class.getName(), mbr.getString("MB1004"), true, false, true);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("UseSharedDatabaseForConfigRecord", Boolean.class.getName(), mbr.getString("MB1272"), true, false, true);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("LocalBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1005"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("MasterBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1006"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("BrokerAddress", String.class.getName(), mbr.getString("MB1011"));
        getBrokerInfoByAddrSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("BrokerID", String.class.getName(), mbr.getString("MB1013"));
        getBrokerInfoByIdSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getBrokerAddresses", mbr.getString("MB1021"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBrokerIDs", mbr.getString("MB1022"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getBrokerInfo", mbr.getString("MB1023"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getBrokerInfoByAddress", mbr.getString("MB1010"), getBrokerInfoByAddrSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getBrokerInfoByID", mbr.getString("MB1012"), getBrokerInfoByIdSignature, CompositeData.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        clsNotificationTypes = new String[]{"mq.cluster.broker.down", "mq.cluster.broker.join"};
        brokerNotificationTypes = new String[]{"mq.broker.takeover.complete", "mq.broker.takeover.fail", "mq.broker.takeover.start"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(brokerNotificationTypes, BrokerNotification.class.getName(), mbr.getString("MB1026"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(clsNotificationTypes, ClusterNotification.class.getName(), mbr.getString("MB1024"));
        notifs = mBeanNotificationInfoArray;
        brokerInfoItemNames = new String[]{"Address", "ID", "State", "StateLabel", "NumMsgs", "TakeoverBrokerID", "StatusTimestamp"};
        brokerInfoItemDesc = brokerInfoItemNames;
        itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.LONG};
    }
}

