/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.List;

public class IMQDualThreadService
extends IMQService {
    private static boolean DEBUG = false;
    protected PacketRouter router = null;

    public IMQDualThreadService(String name, int type, PacketRouter router) {
        super(name, type);
        this.router = router;
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] args = new String[]{this.getName(), "in-process connections", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", args);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException e) {
            this.logger.log(16, "B2135", (Object)this.getName(), e.getMessage());
        }
        if (startPaused) {
            this.setServiceRunning(false);
            this.setState(4);
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        List<Connection> cons;
        IMQDualThreadService iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), "none"};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
            this.notifyAll();
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            this.setState(6);
            this.notifyAll();
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), "none");
        }
    }

    @Override
    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNewConnections() throws IOException {
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQDualThreadService iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    @Override
    public void pauseService(boolean all) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] strings = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setServiceRunning(true);
        IMQDualThreadService iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    public IMQDualThreadConnection createConnection() throws IOException, BrokerException {
        IMQDualThreadConnection con = new IMQDualThreadConnection(this, this.router);
        this.connectionList.addConnection(con);
        return con;
    }
}

