/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsservice;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsservice.Consumer;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import javax.transaction.xa.Xid;

public interface JMSService {
    public static final long DEFAULT_TIME_TO_LIVE = 0L;
    public static final long DEFAULT_DELIVERY_DELAY = 0L;
    public static final MessageDeliveryMode DEFAULT_MessageDeliveryMode = MessageDeliveryMode.PERSISTENT;
    public static final MessagePriority DEFAULT_MessagePriority = MessagePriority.PRIORITY_4;

    public String getJMSServiceID();

    public JMSServiceReply createConnection(String var1, String var2) throws JMSServiceException;

    public JMSServiceReply destroyConnection(long var1) throws JMSServiceException;

    public long[] generateUID(long var1, int var3) throws JMSServiceException;

    public long generateUID(long var1) throws JMSServiceException;

    public JMSServiceReply setClientId(long var1, String var3, boolean var4, String var5) throws JMSServiceException;

    public JMSServiceReply unsetClientId(long var1) throws JMSServiceException;

    public JMSServiceReply startConnection(long var1) throws JMSServiceException;

    public JMSServiceReply stopConnection(long var1) throws JMSServiceException;

    public JMSServiceReply createSession(long var1, SessionAckMode var3) throws JMSServiceException;

    public JMSServiceReply destroySession(long var1, long var3) throws JMSServiceException;

    public JMSServiceReply startSession(long var1, long var3) throws JMSServiceException;

    public JMSServiceReply stopSession(long var1, long var3, boolean var5) throws JMSServiceException;

    public JMSServiceReply stopSession(long var1, long var3) throws JMSServiceException;

    public JMSServiceReply verifyDestination(long var1, Destination var3) throws JMSServiceException;

    public JMSServiceReply createDestination(long var1, Destination var3) throws JMSServiceException;

    public JMSServiceReply destroyDestination(long var1, Destination var3) throws JMSServiceException;

    public JMSServiceReply addProducer(long var1, long var3, Destination var5) throws JMSServiceException;

    public JMSServiceReply deleteProducer(long var1, long var3, long var5) throws JMSServiceException;

    public JMSServiceReply addConsumer(long var1, long var3, Destination var5, String var6, String var7, boolean var8, boolean var9, boolean var10, String var11, boolean var12) throws JMSServiceException;

    public JMSServiceReply deleteConsumer(long var1, long var3, long var5, SysMessageID var7, boolean var8, String var9, String var10) throws JMSServiceException;

    public JMSServiceReply setConsumerAsync(long var1, long var3, long var5, Consumer var7) throws JMSServiceException;

    public JMSServiceReply addBrowser(long var1, long var3, Destination var5, String var6) throws JMSServiceException;

    public JMSServiceReply deleteBrowser(long var1, long var3, long var5) throws JMSServiceException;

    public JMSServiceReply startTransaction(long var1, long var3, Xid var5, int var6, TransactionAutoRollback var7, long var8) throws JMSServiceException;

    public JMSServiceReply endTransaction(long var1, long var3, Xid var5, int var6) throws JMSServiceException;

    public JMSServiceReply prepareTransaction(long var1, long var3, Xid var5) throws JMSServiceException;

    public JMSServiceReply commitTransaction(long var1, long var3, Xid var5, int var6) throws JMSServiceException;

    public JMSServiceReply rollbackTransaction(long var1, long var3, Xid var5, boolean var6, boolean var7, int var8, boolean var9) throws JMSServiceException;

    public JMSServiceReply rollbackTransaction(long var1, long var3, Xid var5, boolean var6, boolean var7) throws JMSServiceException;

    public Xid[] recoverXATransactions(long var1, int var3) throws JMSServiceException;

    public long recoverTransaction(long var1, long var3) throws JMSServiceException;

    public JMSServiceReply sendMessage(long var1, JMSPacket var3) throws JMSServiceException;

    public JMSPacket fetchMessage(long var1, long var3, long var5, long var7, boolean var9, long var10) throws JMSServiceException;

    public JMSServiceReply acknowledgeMessage(long var1, long var3, long var5, SysMessageID var7, long var8, MessageAckType var10) throws JMSServiceException;

    public JMSServiceReply acknowledgeMessage(long var1, long var3, long var5, SysMessageID var7, long var8, MessageAckType var10, int var11) throws JMSServiceException;

    public JMSServiceReply acknowledgeMessage(long var1, long var3, long var5, SysMessageID var7, long var8, MessageAckType var10, int var11, String var12, Throwable var13) throws JMSServiceException;

    public JMSPacket[] browseMessages(long var1, long var3, long var5) throws JMSServiceException;

    public JMSServiceReply redeliverMessages(long var1, long var3, SysMessageID[] var5, Long[] var6, long var7, boolean var9) throws JMSServiceException;

    public JMSServiceReply sendAcknowledgement(long var1, MessageAckType var3, JMSPacket var4) throws JMSServiceException;

    public static enum JMSXProperties {
        JMSXGroupID,
        JMSXGroupSeq,
        JMSXAppID,
        JMSXUserID,
        JMSXProducerTXID,
        JMSXConsumerTXID,
        JMSXRcvTimestamp,
        JMSXDeliveryCount;

    }

    public static enum MessageAckType {
        ACKNOWLEDGE,
        UNDELIVERABLE,
        DEAD;

    }

    public static enum TransactionAutoRollback {
        UNSPECIFIED,
        LESSTHAN_COMMITTED,
        LESSTHAN_PREPARED,
        DISABLED;

    }

    public static enum TransactionState {
        UNKNOWN,
        CREATED,
        STARTED,
        FAILED,
        INCOMPLETE,
        COMPLETE,
        PREPARED,
        COMMITED,
        ROLLEDBACK,
        TIMEDOUT;

    }

    public static enum SessionAckMode {
        UNSPECIFIED,
        TRANSACTED,
        AUTO_ACKNOWLEDGE,
        CLIENT_ACKNOWLEDGE,
        DUPS_OK_ACKNOWLEDGE,
        NO_ACKNOWLEDGE;

    }

    public static enum MessagePriority {
        PRIORITY_0(0),
        PRIORITY_1(1),
        PRIORITY_2(2),
        PRIORITY_3(3),
        PRIORITY_4(4),
        PRIORITY_5(5),
        PRIORITY_6(6),
        PRIORITY_7(7),
        PRIORITY_8(8),
        PRIORITY_9(9);

        private int pri = 4;

        private MessagePriority(int pri) {
            this.pri = pri;
        }

        public int priority() {
            return this.pri;
        }
    }

    public static enum MessageDeliveryMode {
        NON_PERSISTENT,
        PERSISTENT;

    }
}

