/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PortMapperTable {
    private static boolean DEBUG = false;
    public static final int PORTMAPPER_VERSION = 101;
    public static final String DOT = ".";
    public static final String NEWLINE = "\n";
    public static final String SPACE = " ";
    public static final byte NEWLINE_BYTE = 10;
    public static final byte DOT_BYTE = 46;
    public static final byte SPACE_BYTE = 32;
    private String brokerInstance = "???";
    private String packetVersion = "???";
    private String version = "???";
    private Map table = null;

    public PortMapperTable() {
        try {
            Class<?> c = Class.forName("java.util.LinkedHashMap");
            Map m = (Map)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.table = Collections.synchronizedMap(m);
        }
        catch (Throwable ex) {
            this.table = Collections.synchronizedMap(new HashMap());
        }
        this.version = Integer.toString(101);
    }

    public void add(PortMapperEntry e) {
        this.table.remove(e.getName());
        this.table.put(e.getName(), e);
    }

    public PortMapperEntry get(String name) {
        return (PortMapperEntry)this.table.get(name);
    }

    public void remove(String name) {
        this.table.remove(name);
    }

    public void remove(PortMapperEntry e) {
        this.table.remove(e.getName());
    }

    public void setBrokerInstanceName(String name) {
        this.brokerInstance = name;
    }

    public void setPacketVersion(String s) {
        this.packetVersion = s;
    }

    public String getBrokerInstanceName() {
        return this.brokerInstance;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPacketVersion() {
        return this.packetVersion;
    }

    public Map getServices() {
        return this.table;
    }

    public int getPortForService(String service) {
        PortMapperEntry pme = (PortMapperEntry)this.table.get(service);
        if (pme == null) {
            return -1;
        }
        return pme.getPort();
    }

    public String toString() {
        return this.version + SPACE + this.brokerInstance + SPACE + this.packetVersion + this.table;
    }

    public void write(OutputStream out) throws IOException {
        StringBuilder data = new StringBuilder();
        data.append(101).append(SPACE).append(this.brokerInstance).append(SPACE).append(this.packetVersion).append(NEWLINE);
        for (String name : this.table.keySet()) {
            PortMapperEntry pme = (PortMapperEntry)this.table.get(name);
            data.append(pme).append(NEWLINE);
        }
        data.append(".\n");
        out.write(data.toString().getBytes("ASCII"));
        out.flush();
    }

    public void read(InputStream is) throws IOException {
        BufferedInputStream in = new BufferedInputStream(is);
        byte[] buffer = new byte[2048];
        int nBytes = 0;
        if (DEBUG) {
            System.err.println(this.getClass().getName() + ".read():");
        }
        if ((nBytes = this.readLine(in, buffer)) < 0) {
            throw new IOException(SharedResources.getResources().getString("S4011"));
        }
        StringTokenizer st = new StringTokenizer(new String(buffer, "ASCII"));
        int ver = -1;
        try {
            this.version = st.nextToken();
            ver = Integer.parseInt(this.version);
        }
        catch (Exception e) {
            throw new IOException(SharedResources.getResources().getString("S4006", String.valueOf(this.version), String.valueOf(101)), e);
        }
        if (ver != 101) {
            throw new IOException(SharedResources.getResources().getString("S4006", String.valueOf(this.version), String.valueOf(101)));
        }
        this.brokerInstance = st.nextToken();
        this.packetVersion = st.nextToken();
        while ((nBytes = this.readLine(in, buffer)) > 0 && (nBytes != 1 || buffer[0] != 46)) {
            PortMapperEntry pme = PortMapperEntry.parse(new String(buffer, 0, nBytes, "ASCII"));
            this.add(pme);
        }
    }

    private int readLine(InputStream in, byte[] buffer) throws IOException {
        int b = 0;
        int n = 0;
        b = in.read();
        while (b != -1 && b != 10) {
            if (n < buffer.length) {
                buffer[n] = (byte)b;
                ++n;
            }
            b = in.read();
        }
        if (DEBUG) {
            try {
                System.err.println(new String(buffer, 0, n, "ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (n == 0 && b == -1) {
            return -1;
        }
        return n;
    }
}

