/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveMerger
extends ThreeWayMerger {
    private NameConflictTreeWalk tw;
    private String[] commitNames;
    private static final int T_BASE = 0;
    private static final int T_OURS = 1;
    private static final int T_THEIRS = 2;
    private static final int T_INDEX = 3;
    private static final int T_FILE = 4;
    private DirCacheBuilder builder;
    private ObjectId resultTree;
    private List<String> unmergedPaths = new ArrayList<String>();
    private List<String> modifiedFiles = new LinkedList<String>();
    private Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
    private Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    private Map<String, MergeFailureReason> failingPaths = new HashMap<String, MergeFailureReason>();
    private ObjectInserter oi;
    private boolean enterSubtree;
    private boolean inCore;
    private DirCache dircache;
    private WorkingTreeIterator workingTreeIterator;
    private MergeAlgorithm mergeAlgorithm;

    protected ResolveMerger(Repository local, boolean inCore) {
        super(local);
        DiffAlgorithm.SupportedAlgorithm diffAlg = local.getConfig().getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        this.mergeAlgorithm = new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlg));
        this.commitNames = new String[]{"BASE", "OURS", "THEIRS"};
        this.oi = this.getObjectInserter();
        this.inCore = inCore;
        if (inCore) {
            this.dircache = DirCache.newInCore();
        }
    }

    protected ResolveMerger(Repository local) {
        this(local, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean mergeImpl() throws IOException {
        boolean bl;
        boolean implicitDirCache;
        block11: {
            boolean bl2;
            block10: {
                implicitDirCache = false;
                if (this.dircache == null) {
                    this.dircache = this.getRepository().lockDirCache();
                    implicitDirCache = true;
                }
                try {
                    this.builder = this.dircache.builder();
                    DirCacheBuildIterator buildIt = new DirCacheBuildIterator(this.builder);
                    this.tw = new NameConflictTreeWalk(this.db);
                    this.tw.addTree(this.mergeBase());
                    this.tw.addTree(this.sourceTrees[0]);
                    this.tw.addTree(this.sourceTrees[1]);
                    this.tw.addTree(buildIt);
                    if (this.workingTreeIterator != null) {
                        this.tw.addTree(this.workingTreeIterator);
                    }
                    while (this.tw.next()) {
                        if (!this.processEntry(this.tw.getTree(0, CanonicalTreeParser.class), this.tw.getTree(1, CanonicalTreeParser.class), this.tw.getTree(2, CanonicalTreeParser.class), this.tw.getTree(3, DirCacheBuildIterator.class), this.workingTreeIterator == null ? null : this.tw.getTree(4, WorkingTreeIterator.class))) {
                            this.cleanUp();
                            boolean bl3 = false;
                            Object var5_6 = null;
                            if (!implicitDirCache) return bl3;
                            this.dircache.unlock();
                            return bl3;
                        }
                        if (!this.tw.isSubtree() || !this.enterSubtree) continue;
                        this.tw.enterSubtree();
                    }
                    if (!this.inCore) {
                        if (!this.builder.commit()) {
                            this.cleanUp();
                            throw new IndexWriteException();
                        }
                        this.builder = null;
                        this.checkout();
                    } else {
                        this.builder.finish();
                        this.builder = null;
                    }
                    if (this.getUnmergedPaths().isEmpty()) {
                        this.resultTree = this.dircache.writeTree(this.oi);
                        bl2 = true;
                        break block10;
                    }
                    this.resultTree = null;
                    bl = false;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (!implicitDirCache) throw throwable;
                    this.dircache.unlock();
                    throw throwable;
                }
            }
            Object var5_7 = null;
            if (!implicitDirCache) return bl2;
            this.dircache.unlock();
            return bl2;
        }
        Object var5_8 = null;
        if (!implicitDirCache) return bl;
        this.dircache.unlock();
        return bl;
    }

    private void checkout() throws NoWorkTreeException, IOException {
        for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
            File f = new File(this.db.getWorkTree(), entry.getKey());
            if (entry.getValue() != null) {
                this.createDir(f.getParentFile());
                DirCacheCheckout.checkoutEntry(this.db, f, entry.getValue());
            } else if (!f.delete()) {
                this.failingPaths.put(entry.getKey(), MergeFailureReason.COULD_NOT_DELETE);
            }
            this.modifiedFiles.add(entry.getKey());
        }
    }

    private void createDir(File f) throws IOException {
        if (!f.isDirectory() && !f.mkdirs()) {
            File p;
            for (p = f; p != null && !p.exists(); p = p.getParentFile()) {
            }
            if (p == null || p.isDirectory()) {
                throw new IOException(JGitText.get().cannotCreateDirectory);
            }
            FileUtils.delete(p);
            if (!f.mkdirs()) {
                throw new IOException(JGitText.get().cannotCreateDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() throws NoWorkTreeException, CorruptObjectException, IOException {
        if (this.inCore) {
            this.modifiedFiles.clear();
            return;
        }
        DirCache dc = this.db.readDirCache();
        ObjectReader or = this.db.getObjectDatabase().newReader();
        Iterator<String> mpathsIt = this.modifiedFiles.iterator();
        while (mpathsIt.hasNext()) {
            Object var8_7;
            String mpath = mpathsIt.next();
            DirCacheEntry entry = dc.getEntry(mpath);
            FileOutputStream fos = new FileOutputStream(new File(this.db.getWorkTree(), mpath));
            try {
                or.open(entry.getObjectId()).copyTo(fos);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                fos.close();
                throw throwable;
            }
            fos.close();
            mpathsIt.remove();
        }
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(p.getEntryFileMode());
            e.setObjectId(p.getEntryObjectId());
            this.builder.add(e);
            return e;
        }
        return null;
    }

    private boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        if (ResolveMerger.nonTree(modeO) && modeO == modeT && this.tw.idEqual(1, 2)) {
            this.add(this.tw.getRawPath(), ours, 0);
            return true;
        }
        if (ResolveMerger.nonTree(modeO) && modeB == modeT && this.tw.idEqual(0, 2)) {
            this.add(this.tw.getRawPath(), ours, 0);
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty()) {
                return false;
            }
            if (ResolveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0);
                if (e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
                return true;
            }
            if (modeT == 0 && modeB != 0) {
                this.toBeCheckedOut.put(this.tw.getPathString(), null);
                return true;
            }
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(modeO) && !ResolveMerger.nonTree(modeT)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1);
                }
                this.add(this.tw.getRawPath(), ours, 2);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (ResolveMerger.nonTree(modeT) && !ResolveMerger.nonTree(modeO)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1);
                }
                this.add(this.tw.getRawPath(), theirs, 3);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT)) {
            if (this.isWorktreeDirty()) {
                return false;
            }
            if (!this.contentMerge(base, ours, theirs)) {
                this.unmergedPaths.add(this.tw.getPathString());
            }
            this.modifiedFiles.add(this.tw.getPathString());
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            this.add(this.tw.getRawPath(), base, 1);
            this.add(this.tw.getRawPath(), ours, 2);
            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 3);
            if (modeO == 0) {
                if (this.isWorktreeDirty()) {
                    return false;
                }
                if (ResolveMerger.nonTree(modeT) && e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
            }
            this.unmergedPaths.add(this.tw.getPathString());
            RawText baseText = base == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(base.getEntryObjectId(), this.db);
            RawText ourText = ours == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(ours.getEntryObjectId(), this.db);
            RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(theirs.getEntryObjectId(), this.db);
            MergeResult<RawText> result = this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ourText, theirsText);
            this.mergeResults.put(this.tw.getPathString(), result);
        }
        return true;
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeI) && (!this.tw.idEqual(3, 1) || modeO != modeI);
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeF) && (!this.tw.idEqual(4, 1) || modeO != modeF);
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) throws FileNotFoundException, IllegalStateException, IOException {
        File of;
        MergeResult<RawText> result;
        block12: {
            MergeFormatter fmt = new MergeFormatter();
            RawText baseText = base == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(base.getEntryObjectId(), this.db);
            result = this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ResolveMerger.getRawText(ours.getEntryObjectId(), this.db), ResolveMerger.getRawText(theirs.getEntryObjectId(), this.db));
            of = null;
            if (!this.inCore) {
                File workTree = this.db.getWorkTree();
                if (workTree == null) {
                    throw new UnsupportedOperationException();
                }
                of = new File(workTree, this.tw.getPathString());
                FileOutputStream fos = new FileOutputStream(of);
                try {
                    fmt.formatMerge(fos, result, Arrays.asList(this.commitNames), "UTF-8");
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                {
                    break block12;
                }
            }
            if (!result.containsConflicts()) {
                of = File.createTempFile("merge_", "_temp", null);
                FileOutputStream fos = new FileOutputStream(of);
                try {
                    fmt.formatMerge(fos, result, Arrays.asList(this.commitNames), "UTF-8");
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                {
                }
            }
        }
        if (result.containsConflicts()) {
            this.add(this.tw.getRawPath(), base, 1);
            this.add(this.tw.getRawPath(), ours, 2);
            this.add(this.tw.getRawPath(), theirs, 3);
            this.mergeResults.put(this.tw.getPathString(), result);
            return false;
        }
        DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
        dce.setFileMode(this.tw.getFileMode(0));
        dce.setLastModified(of.lastModified());
        dce.setLength((int)of.length());
        FileInputStream is = new FileInputStream(of);
        try {
            dce.setObjectId(this.oi.insert(3, of.length(), is));
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            ((InputStream)is).close();
            if (this.inCore) {
                FileUtils.delete(of);
            }
            throw throwable;
        }
        ((InputStream)is).close();
        if (this.inCore) {
            FileUtils.delete(of);
        }
        this.builder.add(dce);
        return true;
    }

    private static RawText getRawText(ObjectId id, Repository db) throws IOException {
        if (id.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        return new RawText(db.open(id, 3).getCachedBytes());
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, MergeFailureReason> getFailingPaths() {
        return this.failingPaths.size() == 0 ? null : this.failingPaths;
    }

    public boolean failed() {
        return this.failingPaths.size() > 0;
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeFailureReason {
        DIRTY_INDEX,
        DIRTY_WORKTREE,
        COULD_NOT_DELETE;

    }
}

