/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IAliasRegistry;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectParentDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.xfer.TransferResourceDecorator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
IAliasRegistry {
    public static volatile BundleContext bundleContext;
    public static final boolean DEBUG = true;
    public static final String LOCATION_FILE_SERVLET = "/file";
    public static final String LOCATION_PROJECT_SERVLET = "/project";
    public static final String PI_SERVER_SERVLETS = "org.eclipse.orion.server.servlets";
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    static Activator singleton;
    private Map<String, URI> aliases = Collections.synchronizedMap(new HashMap());
    private ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> decoratorTracker;
    private ServiceTracker<ISiteHostingService, ISiteHostingService> siteHostingTracker;
    private URI rootStoreURI;
    private ServiceRegistration<IWebResourceDecorator> transferDecoratorRegistration;
    private ServiceRegistration<IWebResourceDecorator> parentDecoratorRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private synchronized ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> getDecoratorTracker() {
        if (this.decoratorTracker == null) {
            this.decoratorTracker = new ServiceTracker(bundleContext, IWebResourceDecorator.class, null);
            this.decoratorTracker.open();
        }
        return this.decoratorTracker;
    }

    private synchronized ServiceTracker<ISiteHostingService, ISiteHostingService> getSiteHostingTracker() {
        if (this.siteHostingTracker == null) {
            this.siteHostingTracker = new ServiceTracker(bundleContext, ISiteHostingService.class, null);
            this.siteHostingTracker.open();
        }
        return this.siteHostingTracker;
    }

    public IPath getPlatformLocation() {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                return null;
            }
            URL root = location.getURL();
            if (root == null) {
                return null;
            }
            Path path = new Path(root.toExternalForm().substring(5));
            return path;
        }
        finally {
            context.ungetService(ref);
        }
    }

    public URI getRootLocationURI() {
        return this.rootStoreURI;
    }

    public Collection<IWebResourceDecorator> getWebResourceDecorators() {
        ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> tracker = this.getDecoratorTracker();
        return tracker.getTracked().values();
    }

    public ISiteHostingService getSiteHostingService() {
        ServiceTracker<ISiteHostingService, ISiteHostingService> tracker = this.getSiteHostingTracker();
        Collection hostingServices = tracker.getTracked().values();
        return hostingServices.size() == 0 ? null : (ISiteHostingService)hostingServices.iterator().next();
    }

    private void initializeFileSystem() {
        IPath location = this.getPlatformLocation();
        if (location == null) {
            throw new RuntimeException("Unable to compute base file system location");
        }
        IFileStore rootStore = EFS.getLocalFileSystem().getStore(location);
        try {
            rootStore.mkdir(0, null);
            this.rootStoreURI = rootStore.toURI();
        }
        catch (CoreException e) {
            throw new RuntimeException("Instance location is read only: " + rootStore, e);
        }
        if (System.getProperty(PROP_USER_AREA) == null) {
            System.setProperty(PROP_USER_AREA, rootStore.getFileStore((IPath)new Path(".metadata/.plugins/org.eclipse.orion.server.core/userArea")).toString());
        }
    }

    public URI lookupAlias(String alias) {
        return this.aliases.get(alias);
    }

    public void registerAlias(String alias, URI location) {
        this.aliases.put(alias, location);
    }

    public void registerProjectLocation(WebProject project) {
        Path contentPath;
        URI contentURI = project.getContentLocation();
        if ((!contentURI.isAbsolute() || "file".equals(contentURI.getScheme())) && (contentPath = new Path(contentURI.getSchemeSpecificPart())).isAbsolute()) {
            this.registerAlias(project.getId(), contentURI);
        }
    }

    private void registerDecorators() {
        this.transferDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new TransferResourceDecorator(), null);
        this.parentDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new ProjectParentDecorator(), null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.initializeFileSystem();
        this.initializeProjects();
        this.registerDecorators();
    }

    private void initializeProjects() {
        for (WebProject project : WebProject.allProjects()) {
            this.registerProjectLocation(project);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.decoratorTracker != null) {
            this.decoratorTracker.close();
            this.decoratorTracker = null;
        }
        if (this.siteHostingTracker != null) {
            this.siteHostingTracker.close();
            this.siteHostingTracker = null;
        }
        this.unregisterDecorators();
        bundleContext = null;
    }

    public void unregisterAlias(String alias) {
        this.aliases.remove(alias);
    }

    private void unregisterDecorators() {
        if (this.transferDecoratorRegistration != null) {
            this.transferDecoratorRegistration.unregister();
            this.transferDecoratorRegistration = null;
        }
        if (this.parentDecoratorRegistration != null) {
            this.parentDecoratorRegistration.unregister();
            this.parentDecoratorRegistration = null;
        }
    }
}

