/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.task;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.util.tracker.ServiceTracker;

public class TaskServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    ServiceTracker<ITaskService, ITaskService> taskTracker;

    public TaskServlet() {
        this.initTaskService();
    }

    private void initTaskService() {
        this.taskTracker = new ServiceTracker(Activator.bundleContext, ITaskService.class, null);
        this.taskTracker.open();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        if (taskService == null) {
            this.handleException(resp, "Task service is unavailable", null);
            return;
        }
        String taskId = path.segment(1);
        TaskInfo task = taskService.getTask(taskId);
        if (task == null) {
            this.handleException(resp, "Task not found: " + taskId, null, 404);
            return;
        }
        JSONObject result = task.toJSON();
        try {
            if (result.optString("Location", "").equals("")) {
                result.put("Location", (Object)TaskServlet.getURI(req).toString());
            }
        }
        catch (JSONException jSONException) {}
        TaskServlet.writeJSONResponse(req, resp, result);
    }
}

