/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectParentDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        Path resourcePath = new Path(resource.getPath());
        if (resourcePath.segmentCount() < 2) {
            return;
        }
        String service = resourcePath.segment(0);
        if (!"file".equals(service)) {
            return;
        }
        try {
            WebProject project;
            String projectName;
            this.addParents(resource, representation, (IPath)resourcePath);
            if (resourcePath.segmentCount() == 2 && (projectName = (project = WebProject.fromId(resourcePath.segment(1))).getName()) != null) {
                representation.put("Name", (Object)projectName);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addParents(URI resource, JSONObject representation, IPath resourcePath) throws JSONException {
        resourcePath = resourcePath.removeLastSegments(1).addTrailingSeparator();
        JSONArray parents = new JSONArray();
        while (resourcePath.segmentCount() > 2) {
            try {
                URI uri = resource.resolve(new URI(null, resourcePath.toString(), null));
                this.addParent(parents, resourcePath.lastSegment(), new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
            resourcePath = resourcePath.removeLastSegments(1);
        }
        if (resourcePath.segmentCount() == 2) {
            WebProject project = WebProject.fromId(resourcePath.segment(1));
            URI uri = resource.resolve(resourcePath.toString());
            try {
                this.addParent(parents, project.getName(), new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        representation.put("Parents", (Object)parents);
    }

    private void addParent(JSONArray parents, String name, URI location) throws JSONException {
        URI childLocation;
        JSONObject parent = new JSONObject();
        parent.put("Name", (Object)name);
        parent.put("Location", (Object)location);
        try {
            childLocation = new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), "depth=1", location.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        parent.put("ChildrenLocation", (Object)childLocation);
        parents.put((Object)parent);
    }
}

