/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPExportJob;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPImportJob;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPTransferJob;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SFTPTransfer {
    private IFileStore localRoot;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletResourceHandler<IStatus> statusHandler;
    private final List<String> options;

    SFTPTransfer(HttpServletRequest req, HttpServletResponse resp, ServletResourceHandler<IStatus> statusHandler, List<String> options) {
        this.request = req;
        this.response = resp;
        this.statusHandler = statusHandler;
        this.options = options;
        this.initLocalPath();
    }

    public void doTransfer() throws ServletException {
        try {
            this.transferWithExceptions();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException("Internal error during transfer", e, 500);
        }
    }

    private void transferWithExceptions() throws ServletException, IOException, URISyntaxException, JSONException {
        File localFile;
        String passphrase;
        String user;
        int port;
        String remotePath;
        String host;
        try {
            JSONObject requestInfo = OrionServlet.readJSONRequest(this.request);
            host = requestInfo.getString("Host");
            remotePath = requestInfo.getString("Path");
            port = requestInfo.optInt("Port", 22);
            user = requestInfo.getString("UserName");
            passphrase = requestInfo.getString("Passphrase");
        }
        catch (Exception e) {
            this.handleException("Request body is not in the expected format", e, 400);
            return;
        }
        try {
            localFile = this.localRoot.toLocalFile(0, null);
        }
        catch (CoreException e) {
            this.handleException(NLS.bind((String)"Import is not supported at this location: {0}", (Object)this.localRoot.toString()), (Exception)((Object)e), 501);
            return;
        }
        SFTPTransferJob job = "import".equals(new Path(this.request.getPathInfo()).segment(0)) ? new SFTPImportJob(localFile, host, port, (IPath)new Path(remotePath), user, passphrase, this.options) : new SFTPExportJob(localFile, host, port, new Path(remotePath), user, passphrase, this.options);
        job.schedule();
        TaskInfo task = job.getTask();
        JSONObject result = task.toJSON();
        URI requestLocation = ServletResourceHandler.getURI(this.request);
        URI taskLocation = new URI(requestLocation.getScheme(), requestLocation.getAuthority(), "/task/id/" + task.getTaskId(), null, null);
        result.put("Location", (Object)taskLocation);
        this.response.setHeader("Location", taskLocation.toString());
        OrionServlet.writeJSONResponse(this.request, this.response, result);
        this.response.setStatus(202);
    }

    private void handleException(String string, Exception exception, int httpCode) throws ServletException {
        this.statusHandler.handleRequest(this.request, this.response, (IStatus)new ServerStatus(4, httpCode, string, (Throwable)exception));
    }

    private void initLocalPath() {
        Path path = new Path(this.request.getPathInfo());
        this.localRoot = NewFileServlet.getFileStore(path.removeFirstSegments(1).removeFileExtension());
    }
}

