/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class Diff {
    private final DiffFormatter diffFmt;
    private Repository db;
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private Boolean detectRenames;
    private Integer renameLimit;
    private boolean showNameAndStatusOnly;
    private PrintWriter out;

    public Diff(OutputStream outputStream) {
        this.diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(outputStream));
        this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    void setRepository(Repository r) {
        this.db = r;
    }

    void setCached(boolean cached) {
        this.cached = cached;
    }

    void setPathFilter(TreeFilter pf) {
        this.pathFilter = pf;
    }

    void setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
    }

    void setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
    }

    protected void run() throws Exception {
        this.diffFmt.setRepository(this.db);
        try {
            if (this.cached) {
                if (this.oldTree == null) {
                    ObjectId head = this.db.resolve("HEAD^{tree}");
                    if (head == null) {
                        throw new IllegalArgumentException("HEAD is not a tree");
                    }
                    CanonicalTreeParser p = new CanonicalTreeParser();
                    ObjectReader reader = this.db.newObjectReader();
                    try {
                        p.reset(reader, (AnyObjectId)head);
                    }
                    finally {
                        reader.release();
                    }
                    this.oldTree = p;
                }
                this.newTree = new DirCacheIterator(this.db.readDirCache());
            } else if (this.oldTree == null) {
                this.oldTree = new DirCacheIterator(this.db.readDirCache());
                this.newTree = new FileTreeIterator(this.db);
            } else if (this.newTree == null) {
                this.newTree = new FileTreeIterator(this.db);
            }
            this.diffFmt.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
            this.diffFmt.setPathFilter(this.pathFilter);
            if (this.detectRenames != null) {
                this.diffFmt.setDetectRenames(this.detectRenames.booleanValue());
            }
            if (this.renameLimit != null && this.diffFmt.isDetectRenames()) {
                RenameDetector rd = this.diffFmt.getRenameDetector();
                rd.setRenameLimit(this.renameLimit.intValue());
            }
            if (this.showNameAndStatusOnly) {
                Diff.nameStatus(this.out, this.diffFmt.scan(this.oldTree, this.newTree));
                this.out.flush();
            } else {
                this.diffFmt.format(this.oldTree, this.newTree);
                this.diffFmt.flush();
            }
        }
        finally {
            this.diffFmt.release();
        }
    }

    static void nameStatus(PrintWriter out, List<DiffEntry> files) {
        for (DiffEntry ent : files) {
            switch (ent.getChangeType()) {
                case ADD: {
                    out.println("A\t" + ent.getNewPath());
                    break;
                }
                case DELETE: {
                    out.println("D\t" + ent.getOldPath());
                    break;
                }
                case MODIFY: {
                    out.println("M\t" + ent.getNewPath());
                    break;
                }
                case COPY: {
                    out.format("C%1$03d\t%2$s\t%3$s", ent.getScore(), ent.getOldPath(), ent.getNewPath());
                    out.println();
                    break;
                }
                case RENAME: {
                    out.format("R%1$03d\t%2$s\t%3$s", ent.getScore(), ent.getOldPath(), ent.getNewPath());
                    out.println();
                }
            }
        }
    }
}

