/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.git.servlets.GitBranchHandlerV1;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.orion.server.git.servlets.GitCommitHandlerV1;
import org.eclipse.orion.server.git.servlets.GitConfigHandlerV1;
import org.eclipse.orion.server.git.servlets.GitDiffHandlerV1;
import org.eclipse.orion.server.git.servlets.GitIndexHandlerV1;
import org.eclipse.orion.server.git.servlets.GitRemoteHandlerV1;
import org.eclipse.orion.server.git.servlets.GitStatusHandlerV1;
import org.eclipse.orion.server.git.servlets.GitTagHandlerV1;

public class GitHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<String> branchHandlerV1;
    private ServletResourceHandler<String> cloneHandlerV1;
    private ServletResourceHandler<String> commitHandlerV1;
    private ServletResourceHandler<String> configHandlerV1;
    private ServletResourceHandler<String> diffHandlerV1;
    private ServletResourceHandler<String> indexHandlerV1;
    private ServletResourceHandler<String> remoteHandlerV1;
    private ServletResourceHandler<String> statusHandlerV1;
    private ServletResourceHandler<String> tagHandlerV1;

    GitHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.branchHandlerV1 = new GitBranchHandlerV1(statusHandler);
        this.cloneHandlerV1 = new GitCloneHandlerV1(statusHandler);
        this.commitHandlerV1 = new GitCommitHandlerV1(statusHandler);
        this.configHandlerV1 = new GitConfigHandlerV1(statusHandler);
        this.diffHandlerV1 = new GitDiffHandlerV1(statusHandler);
        this.indexHandlerV1 = new GitIndexHandlerV1(statusHandler);
        this.remoteHandlerV1 = new GitRemoteHandlerV1(statusHandler);
        this.statusHandlerV1 = new GitStatusHandlerV1(statusHandler);
        this.tagHandlerV1 = new GitTagHandlerV1(statusHandler);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        String[] infoParts = gitPathInfo.split("\\/", 3);
        if (infoParts[1].equals("branch")) {
            return this.branchHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("clone")) {
            return this.cloneHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("commit")) {
            return this.commitHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("config")) {
            return this.configHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("diff")) {
            return this.diffHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("index")) {
            return this.indexHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("remote")) {
            return this.remoteHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("status")) {
            return this.statusHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        if (infoParts[1].equals("tag")) {
            return this.tagHandlerV1.handleRequest(request, response, (Object)infoParts[2]);
        }
        return false;
    }
}

