/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.openid;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.openid.Activator;
import org.eclipse.orion.server.openid.BundleEntryHttpContext;
import org.eclipse.orion.server.openid.core.OpenIdHelper;
import org.eclipse.orion.server.openid.servlet.AuthInitServlet;
import org.eclipse.orion.server.openid.servlet.OpenIdFormServlet;
import org.eclipse.orion.server.openid.servlet.OpenIdLogoutServlet;
import org.eclipse.orion.server.openid.servlet.OpenidServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class OpenidAuthenticationService
implements IAuthenticationService {
    private HttpService httpService;

    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        return OpenIdHelper.getAuthenticatedUser((HttpServletRequest)req);
    }

    public String getAuthType() {
        return OpenIdHelper.getAuthType();
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        RequestDispatcher rd = req.getRequestDispatcher("/openidform/login?redirect=" + req.getRequestURI());
        try {
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            resp.flushBuffer();
        }
    }

    public void configure(Properties properties) {
        try {
            this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getDefault().getContext().getBundle()));
        }
        catch (Exception exception) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.openid", "Reconfiguring OpenidAuthenticationService"));
            try {
                this.httpService.unregister("/auth2");
                this.httpService.registerServlet("/auth2", (Servlet)new AuthInitServlet(properties), null, (HttpContext)new BundleEntryHttpContext(Activator.getDefault().getContext().getBundle()));
            }
            catch (ServletException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "An error occured when registering servlets", (Throwable)e1));
            }
            catch (NamespaceException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "A namespace error occured when registering servlets", (Throwable)e1));
            }
            catch (IllegalArgumentException e1) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "OpenidAuthenticationService could not be configured", (Throwable)e1));
            }
        }
    }

    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp);
        }
        return user;
    }

    public void setHttpService(HttpService httpService) {
        BundleEntryHttpContext httpContext = new BundleEntryHttpContext(Activator.getDefault().getContext().getBundle());
        this.httpService = httpService;
        try {
            httpService.registerServlet("/openid", (Servlet)new OpenidServlet(), null, (HttpContext)httpContext);
            httpService.registerServlet("/logout", (Servlet)new OpenIdLogoutServlet(), null, (HttpContext)httpContext);
            httpService.registerServlet("/openidform", (Servlet)new OpenIdFormServlet(), null, (HttpContext)httpContext);
            httpService.registerResources("/openidstatic", "/web", (HttpContext)httpContext);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.openid", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService httpService) {
        httpService.unregister("/openid");
        httpService.unregister("openidform");
        httpService.unregister("/openidstatic");
        this.httpService = null;
    }
}

